/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Base64Util;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;

public final class Base64Url {
    private final byte[] bytes;

    public Base64Url(String string) {
        if (string == null) {
            this.bytes = null;
        } else {
            string = Base64Url.unquote(string);
            this.bytes = string.getBytes(StandardCharsets.UTF_8);
        }
    }

    public Base64Url(byte[] byArray) {
        this.bytes = Base64Url.unquote(byArray);
    }

    private static byte[] unquote(byte[] byArray) {
        byte by2;
        byte by3;
        if (byArray != null && byArray.length > 1 && ((by3 = byArray[0]) == 34 || by3 == 39) && (by2 = byArray[byArray.length - 1]) == by3) {
            return Arrays.copyOfRange(byArray, 1, byArray.length - 1);
        }
        return byArray;
    }

    private static String unquote(String string) {
        int n2;
        char c2;
        char c3;
        if (!(CoreUtils.isNullOrEmpty(string) || (c3 = string.charAt(0)) != '\"' && c3 != '\'' || (c2 = string.charAt((n2 = string.length()) - 1)) != c3)) {
            return string.substring(1, n2 - 1);
        }
        return string;
    }

    public static Base64Url encode(byte[] byArray) {
        if (byArray == null) {
            return new Base64Url((String)null);
        }
        return new Base64Url(Base64Util.encodeURLWithoutPadding(byArray));
    }

    public byte[] encodedBytes() {
        return CoreUtils.clone(this.bytes);
    }

    public byte[] decodedBytes() {
        if (this.bytes == null) {
            return null;
        }
        return Base64Util.decodeURL(this.bytes);
    }

    public String toString() {
        return this.bytes == null ? "" : new String(this.bytes, StandardCharsets.UTF_8);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Base64Url)) {
            return false;
        }
        return Arrays.equals(this.bytes, ((Base64Url)object).encodedBytes());
    }
}

