/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.models;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoArray;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoBoundingBox;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoLineString;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoObject;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoObjectType;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPosition;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriter;

public final class GeoLineStringCollection
extends GeoObject {
    private final List<GeoLineString> lines;

    public GeoLineStringCollection(List<GeoLineString> list) {
        this(list, null, null);
    }

    public GeoLineStringCollection(List<GeoLineString> list, GeoBoundingBox geoBoundingBox, Map<String, Object> map) {
        super(geoBoundingBox, map);
        Objects.requireNonNull(list, "'lines' cannot be null.");
        this.lines = Collections.unmodifiableList(new ArrayList<GeoLineString>(list));
    }

    public List<GeoLineString> getLines() {
        return this.lines;
    }

    GeoArray<GeoArray<GeoPosition>> getCoordinates() {
        return new GeoArray<GeoArray<GeoPosition>>(this);
    }

    @Override
    public GeoObjectType getType() {
        return GeoObjectType.MULTI_LINE_STRING;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.lines, super.hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof GeoLineStringCollection)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        GeoLineStringCollection geoLineStringCollection = (GeoLineStringCollection)object;
        return super.equals(object) && Objects.equals(this.lines, geoLineStringCollection.lines);
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter2) throws IOException {
        jsonWriter2.writeStartObject().writeStringField("type", GeoObjectType.MULTI_LINE_STRING.toString()).writeArrayField("coordinates", this.lines, (jsonWriter, geoLineString) -> jsonWriter.writeArray(geoLineString.getCoordinates(), JsonWriter::writeJson)).writeJsonField("bbox", this.getBoundingBox());
        return this.writeCustomProperties(jsonWriter2).writeEndObject();
    }

    public static GeoLineStringCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(jsonReader2 -> {
            ArrayList<GeoLineString> arrayList = null;
            GeoBoundingBox geoBoundingBox = null;
            LinkedHashMap<String, Object> linkedHashMap = null;
            while (jsonReader2.nextToken() != JsonToken.END_OBJECT) {
                Object object;
                String string = jsonReader2.getFieldName();
                jsonReader2.nextToken();
                if ("type".equals(string)) {
                    object = jsonReader2.getString();
                    if (GeoObjectType.MULTI_LINE_STRING.toString().equals(object)) continue;
                    throw new IllegalStateException("'type' was expected to be non-null and equal to 'MultiLineString'. The found 'type' was '" + (String)object + "'.");
                }
                if ("coordinates".equals(string)) {
                    object = jsonReader2.readArray(jsonReader -> jsonReader.readArray(GeoPosition::fromJson));
                    arrayList = new ArrayList<GeoLineString>(object.size());
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        List list = (List)iterator.next();
                        arrayList.add(new GeoLineString(list));
                    }
                    continue;
                }
                if ("bbox".equals(string)) {
                    geoBoundingBox = GeoBoundingBox.fromJson(jsonReader2);
                    continue;
                }
                if (linkedHashMap == null) {
                    linkedHashMap = new LinkedHashMap<String, Object>();
                }
                linkedHashMap.put(string, jsonReader2.readUntyped());
            }
            return new GeoLineStringCollection(arrayList, geoBoundingBox, linkedHashMap);
        });
    }
}

