/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.models;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoBoundingBox;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoObject;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoObjectType;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriter;

public final class GeoCollection
extends GeoObject {
    private final List<GeoObject> geometries;

    public GeoCollection(List<GeoObject> list) {
        this(list, null, null);
    }

    public GeoCollection(List<GeoObject> list, GeoBoundingBox geoBoundingBox, Map<String, Object> map) {
        super(geoBoundingBox, map);
        Objects.requireNonNull(list, "'geometries' cannot be null.");
        this.geometries = Collections.unmodifiableList(new ArrayList<GeoObject>(list));
    }

    public List<GeoObject> getGeometries() {
        return this.geometries;
    }

    @Override
    public GeoObjectType getType() {
        return GeoObjectType.GEOMETRY_COLLECTION;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.geometries, super.hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof GeoCollection)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        GeoCollection geoCollection = (GeoCollection)object;
        return super.equals(geoCollection) && Objects.equals(this.geometries, geoCollection.geometries);
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject().writeStringField("type", GeoObjectType.GEOMETRY_COLLECTION.toString()).writeArrayField("geometries", this.geometries, JsonWriter::writeJson).writeJsonField("bbox", this.getBoundingBox());
        return this.writeCustomProperties(jsonWriter).writeEndObject();
    }

    public static GeoCollection fromJson(JsonReader jsonReader2) throws IOException {
        return jsonReader2.readObject(jsonReader -> {
            List<GeoObject> list = null;
            GeoBoundingBox geoBoundingBox = null;
            LinkedHashMap<String, Object> linkedHashMap = null;
            while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
                String string = jsonReader.getFieldName();
                jsonReader.nextToken();
                if ("type".equals(string)) {
                    String string2 = jsonReader.getString();
                    if (GeoObjectType.GEOMETRY_COLLECTION.toString().equals(string2)) continue;
                    throw new IllegalStateException("'type' was expected to be non-null and equal to 'GeometryCollection'. The found 'type' was '" + string2 + "'.");
                }
                if ("geometries".equals(string)) {
                    list = jsonReader.readArray(GeoObject::fromJson);
                    continue;
                }
                if ("bbox".equals(string)) {
                    geoBoundingBox = GeoBoundingBox.fromJson(jsonReader);
                    continue;
                }
                if (linkedHashMap == null) {
                    linkedHashMap = new LinkedHashMap<String, Object>();
                }
                linkedHashMap.put(string, jsonReader.readUntyped());
            }
            return new GeoCollection(list, geoBoundingBox, linkedHashMap);
        });
    }
}

