/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.models;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoLineStringCollection;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPointCollection;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPolygon;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPolygonCollection;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

final class GeoArray<T>
extends AbstractList<T> {
    private static final String NO_MUTATION_MESSAGE = "GeoArray cannot be mutated.";
    private static final ClientLogger LOGGER = new ClientLogger(GeoArray.class);
    private final Object container;

    GeoArray(Object object) {
        this.container = object;
    }

    @Override
    public T get(int n2) {
        if (this.container instanceof List) {
            return (T)((List)this.container).get(n2);
        }
        if (this.container instanceof GeoPointCollection) {
            return (T)((GeoPointCollection)this.container).getPoints().get(n2).getCoordinates();
        }
        if (this.container instanceof GeoLineStringCollection) {
            return (T)((GeoLineStringCollection)this.container).getLines().get(n2).getCoordinates();
        }
        if (this.container instanceof GeoPolygon) {
            return (T)((GeoPolygon)this.container).getRings().get(n2).getCoordinates();
        }
        if (this.container instanceof GeoPolygonCollection) {
            return (T)((GeoPolygonCollection)this.container).getPolygons().get(n2).getCoordinates();
        }
        throw LOGGER.logExceptionAsError(new IllegalStateException());
    }

    @Override
    public int size() {
        if (this.container instanceof List) {
            return ((List)this.container).size();
        }
        if (this.container instanceof GeoPointCollection) {
            return ((GeoPointCollection)this.container).getPoints().size();
        }
        if (this.container instanceof GeoLineStringCollection) {
            return ((GeoLineStringCollection)this.container).getLines().size();
        }
        if (this.container instanceof GeoPolygon) {
            return ((GeoPolygon)this.container).getRings().size();
        }
        if (this.container instanceof GeoPolygonCollection) {
            return ((GeoPolygonCollection)this.container).getPolygons().size();
        }
        throw LOGGER.logExceptionAsError(new IllegalStateException());
    }

    @Override
    public boolean remove(Object object) {
        throw LOGGER.logExceptionAsError(new UnsupportedOperationException(NO_MUTATION_MESSAGE));
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw LOGGER.logExceptionAsError(new UnsupportedOperationException(NO_MUTATION_MESSAGE));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw LOGGER.logExceptionAsError(new UnsupportedOperationException(NO_MUTATION_MESSAGE));
    }

    @Override
    public void replaceAll(UnaryOperator<T> unaryOperator) {
        throw LOGGER.logExceptionAsError(new UnsupportedOperationException(NO_MUTATION_MESSAGE));
    }

    @Override
    public void sort(Comparator<? super T> comparator) {
        throw LOGGER.logExceptionAsError(new UnsupportedOperationException(NO_MUTATION_MESSAGE));
    }

    @Override
    public boolean removeIf(Predicate<? super T> predicate) {
        throw LOGGER.logExceptionAsError(new UnsupportedOperationException(NO_MUTATION_MESSAGE));
    }

    @Override
    public List<T> subList(int n2, int n3) {
        throw LOGGER.logExceptionAsError(new UnsupportedOperationException("GeoArray does not support sub lists."));
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof GeoArray)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        GeoArray geoArray = (GeoArray)object;
        return Objects.equals(this.container, geoArray.container);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.container);
    }
}

