/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;

public final class Providers<TProvider, TInstance> {
    private static final ClientLogger LOGGER = new ClientLogger(Providers.class);
    private final TProvider defaultProvider;
    private final String defaultProviderName;
    private final Map<String, TProvider> availableProviders;
    private final String defaultImplementation;
    private final boolean noDefaultImplementation;
    private final String noProviderMessage;
    private final Class<TProvider> providerClass;

    public Providers(Class<TProvider> clazz, String string, String string2) {
        this.providerClass = clazz;
        ServiceLoader<TProvider> serviceLoader = ServiceLoader.load(clazz, Providers.class.getClassLoader());
        this.availableProviders = new HashMap<String, TProvider>();
        Iterator<TProvider> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            this.defaultProvider = iterator.next();
            this.defaultProviderName = this.defaultProvider.getClass().getName();
            this.availableProviders.put(this.defaultProviderName, this.defaultProvider);
            LOGGER.log(LogLevel.VERBOSE, () -> "Using " + this.defaultProviderName + " as the default " + clazz.getName() + ".");
        } else {
            this.defaultProvider = null;
            this.defaultProviderName = null;
        }
        while (iterator.hasNext()) {
            TProvider TProvider = iterator.next();
            String string3 = TProvider.getClass().getName();
            this.availableProviders.put(string3, TProvider);
            LOGGER.log(LogLevel.VERBOSE, () -> "Additional provider found on the classpath: " + string3);
        }
        this.defaultImplementation = string;
        this.noDefaultImplementation = CoreUtils.isNullOrEmpty(this.defaultImplementation);
        this.noProviderMessage = string2;
    }

    private String formatNoSpecificProviderErrorMessage(String string) {
        return "A request was made to use a specific " + this.providerClass.getSimpleName() + " but it wasn't found on the classpath. If you're using a dependency manager ensure you're including the dependency that provides the specific implementation. If you're including the specific implementation ensure that the " + this.providerClass.getSimpleName() + " service it supplies is being included in the 'META-INF/services' file '" + this.providerClass.getName() + "'. The requested provider was: " + string + ".";
    }

    public TInstance create(Function<TProvider, TInstance> function, TInstance TInstance, Class<? extends TProvider> clazz) {
        TProvider TProvider;
        String string;
        if (clazz == null && this.noDefaultImplementation) {
            string = this.defaultProviderName;
            TProvider = this.defaultProvider;
            if (TProvider == null) {
                if (TInstance == null) {
                    throw LOGGER.logExceptionAsError(new IllegalStateException(this.noProviderMessage));
                }
                return TInstance;
            }
        } else {
            string = clazz == null ? this.defaultImplementation : clazz.getName();
            TProvider = this.availableProviders.get(string);
            if (TProvider == null) {
                throw LOGGER.logExceptionAsError(new IllegalStateException(this.formatNoSpecificProviderErrorMessage(string)));
            }
        }
        try {
            return function.apply(TProvider);
        }
        catch (ClassCastException classCastException) {
            throw LOGGER.logExceptionAsError(new IllegalStateException(this.formatNoSpecificProviderErrorMessage(string), classCastException));
        }
    }
}

