/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Objects;

public class IterableOfByteBuffersInputStream
extends InputStream {
    private final Iterator<ByteBuffer> buffers;
    private ByteBuffer currentBuffer;

    public IterableOfByteBuffersInputStream(Iterable<ByteBuffer> iterable) {
        Objects.requireNonNull(iterable, "'buffers' must not be null");
        this.buffers = iterable.iterator();
    }

    @Override
    public synchronized int read() throws IOException {
        ByteBuffer byteBuffer = this.getCurrentBuffer();
        if (byteBuffer == null) {
            return -1;
        }
        return byteBuffer.get() & 0xFF;
    }

    @Override
    public synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
        ByteBuffer byteBuffer = this.getCurrentBuffer();
        if (byteBuffer == null) {
            return -1;
        }
        int n4 = 0;
        while (n3 > 0 && byteBuffer != null) {
            int n5 = Math.min(byteBuffer.remaining(), n3);
            byteBuffer.get(byArray, n2, n5);
            n4 += n5;
            n2 += n5;
            n3 -= n5;
            byteBuffer = this.getCurrentBuffer();
        }
        return n4;
    }

    @Override
    public synchronized int available() throws IOException {
        ByteBuffer byteBuffer = this.getCurrentBuffer();
        if (byteBuffer == null) {
            return 0;
        }
        return byteBuffer.remaining();
    }

    private ByteBuffer getCurrentBuffer() {
        if (this.currentBuffer != null && this.currentBuffer.hasRemaining()) {
            return this.currentBuffer;
        }
        while (this.buffers.hasNext()) {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = this.buffers.next();
            if (!byteBuffer2.hasRemaining()) continue;
            this.currentBuffer = byteBuffer = byteBuffer2.duplicate();
            return byteBuffer;
        }
        return null;
    }
}

