/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.AccessibleByteArrayOutputStream;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ImplUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.BinaryDataContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.BinaryDataContentType;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.IterableOfByteBuffersInputStream;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.StreamUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.FluxUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.io.IOUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.ObjectSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.TypeReference;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;
import macromedia.jdbc.sqlserver.externals.reactor.core.scheduler.Schedulers;
import macromedia.jdbc.sqlserver.externals.reactor.util.function.Tuple2;

public final class InputStreamContent
extends BinaryDataContent {
    private static final ClientLogger LOGGER = new ClientLogger(InputStreamContent.class);
    private static final int INITIAL_BUFFER_CHUNK_SIZE = 8192;
    private static final int MAX_BUFFER_CHUNK_SIZE = 0x800000;
    private static final int MAX_ARRAY_LENGTH = 0x7FFFFFF7;
    private final Supplier<InputStream> content;
    private final Long length;
    private final boolean isReplayable;
    private final List<ByteBuffer> bufferedContent;
    private volatile byte[] bytes;
    private static final AtomicReferenceFieldUpdater<InputStreamContent, byte[]> BYTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(InputStreamContent.class, byte[].class, "bytes");

    public InputStreamContent(InputStream inputStream, Long l2) {
        Objects.requireNonNull(inputStream, "'inputStream' cannot be null.");
        this.length = l2;
        this.isReplayable = InputStreamContent.canMarkReset(inputStream, l2);
        if (this.isReplayable) {
            inputStream.mark(l2.intValue());
            this.content = () -> InputStreamContent.resettableContent(inputStream);
        } else {
            this.content = () -> inputStream;
        }
        this.bufferedContent = null;
    }

    private InputStreamContent(Supplier<InputStream> supplier, Long l2, List<ByteBuffer> list) {
        this.content = Objects.requireNonNull(supplier, "'inputStreamSupplier' cannot be null.");
        this.length = l2;
        this.isReplayable = true;
        this.bufferedContent = list;
    }

    @Override
    public Long getLength() {
        byte[] byArray = BYTES_UPDATER.get(this);
        if (byArray != null) {
            return byArray.length;
        }
        return this.length;
    }

    @Override
    public String toString() {
        return new String(this.toBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toBytes() {
        return BYTES_UPDATER.updateAndGet(this, byArray -> byArray == null ? this.getBytes() : byArray);
    }

    @Override
    public <T> T toObject(TypeReference<T> typeReference, ObjectSerializer objectSerializer) {
        return objectSerializer.deserializeFromBytes(this.toBytes(), typeReference);
    }

    @Override
    public InputStream toStream() {
        return this.content.get();
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.toBytes()).asReadOnlyBuffer();
    }

    @Override
    public Flux<ByteBuffer> toFluxByteBuffer() {
        if (this.bufferedContent != null) {
            return Flux.fromIterable(this.bufferedContent).map(ByteBuffer::asReadOnlyBuffer);
        }
        return FluxUtil.toFluxByteBuffer(this.content.get(), 8192);
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        this.writeTo(Channels.newChannel(outputStream));
    }

    @Override
    public void writeTo(WritableByteChannel writableByteChannel) throws IOException {
        InputStream inputStream = this.content.get();
        if (this.bufferedContent != null) {
            for (ByteBuffer byteBuffer : this.bufferedContent) {
                ImplUtils.fullyWriteBuffer(byteBuffer.duplicate(), writableByteChannel);
            }
        } else {
            IOUtils.transfer(Channels.newChannel(inputStream), writableByteChannel, this.length);
        }
    }

    @Override
    public Mono<Void> writeTo(AsynchronousByteChannel asynchronousByteChannel) {
        if (asynchronousByteChannel == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'channel' cannot be null."));
        }
        return FluxUtil.writeToAsynchronousByteChannel(this.toFluxByteBuffer(), asynchronousByteChannel);
    }

    @Override
    public boolean isReplayable() {
        return this.isReplayable;
    }

    @Override
    public BinaryDataContent toReplayableContent() {
        if (this.isReplayable) {
            return this;
        }
        return InputStreamContent.readAndBuffer(this.content.get(), this.length);
    }

    @Override
    public Mono<BinaryDataContent> toReplayableContentAsync() {
        if (this.isReplayable) {
            return Mono.just((Object)this);
        }
        InputStream inputStream2 = this.content.get();
        return Mono.just((Object)inputStream2).publishOn(Schedulers.boundedElastic()).map(inputStream -> InputStreamContent.readAndBuffer(inputStream, this.length));
    }

    @Override
    public BinaryDataContentType getContentType() {
        return BinaryDataContentType.BINARY;
    }

    private static boolean canMarkReset(InputStream inputStream, Long l2) {
        return l2 != null && l2 < 0x7FFFFFF7L && inputStream.markSupported();
    }

    private static InputStream resettableContent(InputStream inputStream) {
        try {
            inputStream.reset();
            return inputStream;
        }
        catch (IOException iOException) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(iOException));
        }
    }

    private static InputStreamContent readAndBuffer(InputStream inputStream, Long l2) {
        try {
            Tuple2<Long, List<ByteBuffer>> tuple2 = StreamUtil.readStreamToListOfByteBuffers(inputStream, l2, 8192, 0x800000);
            long l3 = (Long)tuple2.getT1();
            List list = (List)tuple2.getT2();
            if (l2 == null || l2 != l3) {
                return new InputStreamContent(() -> new IterableOfByteBuffersInputStream(list), l3, list);
            }
            return new InputStreamContent(() -> new IterableOfByteBuffersInputStream(list), l2, list);
        }
        catch (IOException iOException) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(iOException));
        }
    }

    private byte[] getBytes() {
        try {
            int n2;
            AccessibleByteArrayOutputStream accessibleByteArrayOutputStream = this.length == null || this.length < 0x7FFFFFF7L ? new AccessibleByteArrayOutputStream() : new AccessibleByteArrayOutputStream(this.length.intValue());
            byte[] byArray = new byte[8192];
            InputStream inputStream = this.content.get();
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                accessibleByteArrayOutputStream.write(byArray, 0, n2);
            }
            return accessibleByteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(iOException));
        }
    }
}

