/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.serializer;

import java.io.Closeable;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.serializer.HttpResponseBodyDecoder;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.serializer.HttpResponseDecodeData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.serializer.HttpResponseHeaderDecoder;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.SerializerAdapter;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public final class HttpResponseDecoder {
    private final SerializerAdapter serializer;

    public HttpResponseDecoder(SerializerAdapter serializerAdapter) {
        this.serializer = serializerAdapter;
    }

    public Mono<HttpDecodedResponse> decode(Mono<HttpResponse> mono, HttpResponseDecodeData httpResponseDecodeData) {
        return mono.map(httpResponse -> new HttpDecodedResponse((HttpResponse)httpResponse, this.serializer, httpResponseDecodeData));
    }

    public HttpDecodedResponse decodeSync(HttpResponse httpResponse, HttpResponseDecodeData httpResponseDecodeData) {
        return new HttpDecodedResponse(httpResponse, this.serializer, httpResponseDecodeData);
    }

    public static class HttpDecodedResponse
    implements Closeable {
        private final HttpResponse response;
        private final SerializerAdapter serializer;
        private final HttpResponseDecodeData decodeData;
        private Object bodyCached;
        private Object headersCached;

        HttpDecodedResponse(HttpResponse httpResponse, SerializerAdapter serializerAdapter, HttpResponseDecodeData httpResponseDecodeData) {
            this.response = httpResponse;
            this.serializer = serializerAdapter;
            this.decodeData = httpResponseDecodeData;
        }

        public HttpResponse getSourceResponse() {
            return this.response;
        }

        public Object getDecodedBody(byte[] byArray) {
            if (this.bodyCached == null) {
                this.bodyCached = HttpResponseBodyDecoder.decodeByteArray(byArray, this.response, this.serializer, this.decodeData);
            }
            return this.bodyCached;
        }

        public Object getDecodedHeaders() {
            if (this.headersCached == null) {
                this.headersCached = HttpResponseHeaderDecoder.decode(this.response, this.serializer, this.decodeData.getHeadersType());
            }
            return this.headersCached;
        }

        @Override
        public void close() {
            this.response.close();
        }
    }
}

