/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.serializer;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.HttpResponseException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.Page;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.Response;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectionSerializable;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.TypeUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.serializer.HttpResponseDecodeData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.serializer.ItemPage;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.serializer.MalformedValueException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Base64Url;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.DateTimeRfc1123;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.SerializerAdapter;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.SerializerEncoding;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public final class HttpResponseBodyDecoder {
    private static final ClientLogger LOGGER = new ClientLogger(HttpResponseBodyDecoder.class);

    static Object decodeByteArray(byte[] byArray, HttpResponse httpResponse, SerializerAdapter serializerAdapter, HttpResponseDecodeData httpResponseDecodeData) {
        HttpResponseBodyDecoder.ensureRequestSet(httpResponse);
        if (httpResponse.getRequest().getHttpMethod() == HttpMethod.HEAD) {
            return null;
        }
        if (HttpResponseBodyDecoder.isErrorStatus(httpResponse.getStatusCode(), httpResponseDecodeData)) {
            try {
                if (byArray == null || byArray.length == 0) {
                    return null;
                }
                return HttpResponseBodyDecoder.deserializeBody(byArray, httpResponseDecodeData.getUnexpectedException(httpResponse.getStatusCode()).getExceptionBodyType(), null, serializerAdapter, SerializerEncoding.fromHeaders(httpResponse.getHeaders()));
            }
            catch (IOException | IllegalStateException | MalformedValueException exception) {
                LOGGER.log(LogLevel.WARNING, () -> "Failed to deserialize the error entity.", exception);
                return exception;
            }
        }
        if (!httpResponseDecodeData.isReturnTypeDecodeable()) {
            return null;
        }
        byte[] byArray2 = byArray == null ? httpResponse.getBodyAsBinaryData().toBytes() : byArray;
        try {
            if (byArray2 == null || byArray2.length == 0) {
                return null;
            }
            return HttpResponseBodyDecoder.deserializeBody(byArray2, HttpResponseBodyDecoder.extractEntityTypeFromReturnType(httpResponseDecodeData), httpResponseDecodeData.getReturnValueWireType(), serializerAdapter, SerializerEncoding.fromHeaders(httpResponse.getHeaders()));
        }
        catch (MalformedValueException malformedValueException) {
            throw new HttpResponseException("HTTP response has a malformed body.", httpResponse, malformedValueException);
        }
        catch (IOException iOException) {
            throw new HttpResponseException("Deserialization Failed.", httpResponse, iOException);
        }
    }

    static Type decodedType(HttpResponse httpResponse, HttpResponseDecodeData httpResponseDecodeData) {
        HttpResponseBodyDecoder.ensureRequestSet(httpResponse);
        if (httpResponse.getRequest().getHttpMethod() == HttpMethod.HEAD) {
            return null;
        }
        if (HttpResponseBodyDecoder.isErrorStatus(httpResponse.getStatusCode(), httpResponseDecodeData)) {
            return httpResponseDecodeData.getUnexpectedException(httpResponse.getStatusCode()).getExceptionBodyType();
        }
        return httpResponseDecodeData.isReturnTypeDecodeable() ? HttpResponseBodyDecoder.extractEntityTypeFromReturnType(httpResponseDecodeData) : null;
    }

    static boolean isErrorStatus(int n2, HttpResponseDecodeData httpResponseDecodeData) {
        return !httpResponseDecodeData.isExpectedResponseStatusCode(n2);
    }

    private static Object deserializeBody(byte[] byArray, Type type, Type type2, SerializerAdapter serializerAdapter, SerializerEncoding serializerEncoding) throws IOException {
        if (type2 == null) {
            return HttpResponseBodyDecoder.deserialize(byArray, type, serializerAdapter, serializerEncoding);
        }
        if (TypeUtil.isTypeOrSubTypeOf(type2, Page.class)) {
            Type type3 = type2 == Page.class ? TypeUtil.createParameterizedType(ItemPage.class, new Type[]{type}) : type2;
            return HttpResponseBodyDecoder.deserialize(byArray, type3, serializerAdapter, serializerEncoding);
        }
        Type type4 = HttpResponseBodyDecoder.constructWireResponseType(type, type2);
        Object object = HttpResponseBodyDecoder.deserialize(byArray, type4, serializerAdapter, serializerEncoding);
        return HttpResponseBodyDecoder.convertToResultType(object, type, type2);
    }

    private static Object deserialize(byte[] byArray, Type type, SerializerAdapter serializerAdapter, SerializerEncoding serializerEncoding) throws IOException {
        Class<?> clazz = TypeUtil.getRawClass(type);
        if (serializerEncoding == SerializerEncoding.JSON && ReflectionSerializable.supportsJsonSerializable(clazz)) {
            return ReflectionSerializable.deserializeAsJsonSerializable(clazz, byArray);
        }
        if (serializerEncoding == SerializerEncoding.XML && ReflectionSerializable.supportsXmlSerializable(clazz)) {
            return ReflectionSerializable.deserializeAsXmlSerializable(clazz, byArray);
        }
        return serializerAdapter.deserialize(byArray, type, serializerEncoding);
    }

    private static Type constructWireResponseType(Type type, Type type2) {
        Objects.requireNonNull(type2);
        if (type == byte[].class) {
            if (type2 == Base64Url.class) {
                return Base64Url.class;
            }
        } else if (type == OffsetDateTime.class) {
            if (type2 == DateTimeRfc1123.class) {
                return DateTimeRfc1123.class;
            }
        } else {
            if (TypeUtil.isTypeOrSubTypeOf(type, List.class)) {
                Type type3 = TypeUtil.getTypeArgument(type);
                Type type4 = HttpResponseBodyDecoder.constructWireResponseType(type3, type2);
                return TypeUtil.createParameterizedType(((ParameterizedType)type).getRawType(), type4);
            }
            if (TypeUtil.isTypeOrSubTypeOf(type, Map.class)) {
                Type[] typeArray = TypeUtil.getTypeArguments(type);
                Type type5 = typeArray[1];
                Type type6 = HttpResponseBodyDecoder.constructWireResponseType(type5, type2);
                return TypeUtil.createParameterizedType(((ParameterizedType)type).getRawType(), typeArray[0], type6);
            }
        }
        return type;
    }

    private static Object convertToResultType(Object object, Type type, Type type2) {
        if (type == byte[].class) {
            if (type2 == Base64Url.class) {
                return ((Base64Url)object).decodedBytes();
            }
        } else if (type == OffsetDateTime.class) {
            if (type2 == DateTimeRfc1123.class) {
                return ((DateTimeRfc1123)object).getDateTime();
            }
        } else {
            if (TypeUtil.isTypeOrSubTypeOf(type, List.class)) {
                Type type3 = TypeUtil.getTypeArgument(type);
                List list = (List)object;
                int n2 = list.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object object2;
                    Object e2 = list.get(i2);
                    if (e2 == (object2 = HttpResponseBodyDecoder.convertToResultType(e2, type3, type2))) continue;
                    list.set(i2, object2);
                }
                return list;
            }
            if (TypeUtil.isTypeOrSubTypeOf(type, Map.class)) {
                Type type4 = TypeUtil.getTypeArguments(type)[1];
                Map map = (Map)object;
                Set set = map.entrySet();
                for (Map.Entry entry : set) {
                    Object object3;
                    Object v2 = entry.getValue();
                    if (v2 == (object3 = HttpResponseBodyDecoder.convertToResultType(v2, type4, type2))) continue;
                    map.put((String)entry.getKey(), object3);
                }
                return map;
            }
        }
        return object;
    }

    private static Type extractEntityTypeFromReturnType(HttpResponseDecodeData httpResponseDecodeData) {
        Type type = httpResponseDecodeData.getReturnType();
        if (TypeUtil.isTypeOrSubTypeOf(type, Mono.class)) {
            type = TypeUtil.getTypeArgument(type);
        }
        if (TypeUtil.isTypeOrSubTypeOf(type, Response.class)) {
            type = TypeUtil.getRestResponseBodyType(type);
        }
        return type;
    }

    private static void ensureRequestSet(HttpResponse httpResponse) {
        Objects.requireNonNull(httpResponse.getRequest());
        Objects.requireNonNull(httpResponse.getRequest().getHttpMethod());
    }
}

