/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.JacksonAdapter;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.JsonSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.SerializerAdapter;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.SerializerEncoding;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.TypeReference;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public final class DefaultJsonSerializer
implements JsonSerializer {
    private static final ClientLogger LOGGER = new ClientLogger(DefaultJsonSerializer.class);
    private final SerializerAdapter jacksonAdapter = JacksonAdapter.createDefaultSerializerAdapter();

    @Override
    public <T> T deserializeFromBytes(byte[] byArray, TypeReference<T> typeReference) {
        try {
            return this.jacksonAdapter.deserialize(byArray, typeReference.getJavaType(), SerializerEncoding.JSON);
        }
        catch (IOException iOException) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(iOException));
        }
    }

    @Override
    public <T> T deserialize(InputStream inputStream, TypeReference<T> typeReference) {
        try {
            return this.jacksonAdapter.deserialize(inputStream, typeReference.getJavaType(), SerializerEncoding.JSON);
        }
        catch (IOException iOException) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(iOException));
        }
    }

    @Override
    public <T> Mono<T> deserializeFromBytesAsync(byte[] byArray, TypeReference<T> typeReference) {
        return Mono.fromCallable(() -> this.deserializeFromBytes(byArray, typeReference));
    }

    @Override
    public <T> Mono<T> deserializeAsync(InputStream inputStream, TypeReference<T> typeReference) {
        return Mono.fromCallable(() -> this.deserialize(inputStream, typeReference));
    }

    @Override
    public byte[] serializeToBytes(Object object) {
        try {
            return this.jacksonAdapter.serializeToBytes(object, SerializerEncoding.JSON);
        }
        catch (IOException iOException) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(iOException));
        }
    }

    @Override
    public void serialize(OutputStream outputStream, Object object) {
        try {
            this.jacksonAdapter.serialize(object, SerializerEncoding.JSON, outputStream);
        }
        catch (IOException iOException) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(iOException));
        }
    }

    @Override
    public Mono<byte[]> serializeToBytesAsync(Object object) {
        return Mono.fromCallable(() -> this.serializeToBytes(object));
    }

    @Override
    public Mono<Void> serializeAsync(OutputStream outputStream, Object object) {
        return Mono.fromRunnable(() -> this.serialize(outputStream, object));
    }
}

