/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.logging;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.EnvironmentConfiguration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;
import macromedia.jdbc.sqlserver.externals.org.slf4j.helpers.FormattingTuple;
import macromedia.jdbc.sqlserver.externals.org.slf4j.helpers.MarkerIgnoringBase;
import macromedia.jdbc.sqlserver.externals.org.slf4j.helpers.MessageFormatter;

public final class DefaultLogger
extends MarkerIgnoringBase {
    private static final long serialVersionUID = -144261058636441630L;
    private static final String WHITESPACE = " ";
    private static final String HYPHEN = " - ";
    private static final String OPEN_BRACKET = " [";
    private static final String CLOSE_BRACKET = "]";
    public static final String WARN = "WARN";
    public static final String DEBUG = "DEBUG";
    public static final String INFO = "INFO";
    public static final String ERROR = "ERROR";
    public static final String TRACE = "TRACE";
    private final String classPath;
    private final boolean isTraceEnabled;
    private final boolean isDebugEnabled;
    private final boolean isInfoEnabled;
    private final boolean isWarnEnabled;
    private final boolean isErrorEnabled;
    private final PrintStream logLocation;

    public DefaultLogger(Class<?> clazz) {
        this(clazz.getCanonicalName(), System.out, DefaultLogger.fromEnvironment());
    }

    public DefaultLogger(String string) {
        this(DefaultLogger.getClassPathFromClassName(string), System.out, DefaultLogger.fromEnvironment());
    }

    public DefaultLogger(String string, PrintStream printStream, LogLevel logLevel) {
        this.classPath = DefaultLogger.getClassPathFromClassName(string);
        int n2 = logLevel.getLogLevel();
        this.isTraceEnabled = LogLevel.VERBOSE.getLogLevel() > n2;
        this.isDebugEnabled = LogLevel.VERBOSE.getLogLevel() >= n2;
        this.isInfoEnabled = LogLevel.INFORMATIONAL.getLogLevel() >= n2;
        this.isWarnEnabled = LogLevel.WARNING.getLogLevel() >= n2;
        this.isErrorEnabled = LogLevel.ERROR.getLogLevel() >= n2;
        this.logLocation = printStream;
    }

    private static String getClassPathFromClassName(String string) {
        try {
            return Class.forName(string).getCanonicalName();
        }
        catch (ClassNotFoundException | InvalidPathException exception) {
            return string;
        }
    }

    private static LogLevel fromEnvironment() {
        String string = EnvironmentConfiguration.getGlobalConfiguration().get("AZURE_LOG_LEVEL");
        return LogLevel.fromString(string);
    }

    @Override
    public String getName() {
        return this.classPath;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isTraceEnabled;
    }

    @Override
    public void trace(String string) {
        this.logMessageWithFormat(TRACE, string, new Object[0]);
    }

    @Override
    public void trace(String string, Object object) {
        this.logMessageWithFormat(TRACE, string, object);
    }

    @Override
    public void trace(String string, Object object, Object object2) {
        this.logMessageWithFormat(TRACE, string, object, object2);
    }

    @Override
    public void trace(String string, Object ... objectArray) {
        this.logMessageWithFormat(TRACE, string, objectArray);
    }

    @Override
    public void trace(String string, Throwable throwable) {
        this.log(TRACE, string, throwable);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    @Override
    public void debug(String string) {
        this.logMessageWithFormat(DEBUG, string, new Object[0]);
    }

    @Override
    public void debug(String string, Object object) {
        this.logMessageWithFormat(DEBUG, string, object);
    }

    @Override
    public void debug(String string, Object object, Object object2) {
        this.logMessageWithFormat(DEBUG, string, object, object2);
    }

    @Override
    public void debug(String string, Object ... objectArray) {
        this.logMessageWithFormat(DEBUG, string, objectArray);
    }

    @Override
    public void debug(String string, Throwable throwable) {
        this.log(DEBUG, string, throwable);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isInfoEnabled;
    }

    @Override
    public void info(String string) {
        this.logMessageWithFormat(INFO, string, new Object[0]);
    }

    @Override
    public void info(String string, Object object) {
        this.logMessageWithFormat(INFO, string, object);
    }

    @Override
    public void info(String string, Object object, Object object2) {
        this.logMessageWithFormat(INFO, string, object, object2);
    }

    @Override
    public void info(String string, Object ... objectArray) {
        this.logMessageWithFormat(INFO, string, objectArray);
    }

    @Override
    public void info(String string, Throwable throwable) {
        this.log(INFO, string, throwable);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isWarnEnabled;
    }

    @Override
    public void warn(String string) {
        this.logMessageWithFormat(WARN, string, new Object[0]);
    }

    @Override
    public void warn(String string, Object object) {
        this.logMessageWithFormat(WARN, string, object);
    }

    @Override
    public void warn(String string, Object object, Object object2) {
        this.logMessageWithFormat(WARN, string, object, object2);
    }

    @Override
    public void warn(String string, Object ... objectArray) {
        this.logMessageWithFormat(WARN, string, objectArray);
    }

    @Override
    public void warn(String string, Throwable throwable) {
        this.log(WARN, string, throwable);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isErrorEnabled;
    }

    @Override
    public void error(String string, Object object) {
        this.logMessageWithFormat(ERROR, string, object);
    }

    @Override
    public void error(String string) {
        this.logMessageWithFormat(ERROR, string, new Object[0]);
    }

    @Override
    public void error(String string, Object object, Object object2) {
        this.logMessageWithFormat(ERROR, string, object, object2);
    }

    @Override
    public void error(String string, Object ... objectArray) {
        this.logMessageWithFormat(ERROR, string, objectArray);
    }

    @Override
    public void error(String string, Throwable throwable) {
        this.log(ERROR, string, throwable);
    }

    private void logMessageWithFormat(String string, String string2, Object ... objectArray) {
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(string2, objectArray);
        this.log(string, formattingTuple.getMessage(), formattingTuple.getThrowable());
    }

    private void log(String string, String string2, Throwable throwable) {
        String string3 = DefaultLogger.getFormattedDate();
        String string4 = Thread.currentThread().getName();
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(string3).append(OPEN_BRACKET).append(string4).append(CLOSE_BRACKET).append(OPEN_BRACKET).append(string).append(CLOSE_BRACKET).append(WHITESPACE).append(this.classPath).append(HYPHEN).append(string2).append(System.lineSeparator());
        this.writeWithThrowable(stringBuilder, throwable);
    }

    private static String getFormattedDate() {
        LocalDateTime localDateTime = LocalDateTime.now();
        byte[] byArray = new byte[23];
        int n2 = localDateTime.getYear();
        int n3 = n2 / 1000;
        byArray[0] = (byte)(48 + n3);
        n2 -= 1000 * n3;
        n3 = n2 / 100;
        byArray[1] = (byte)(48 + n3);
        n2 -= 100 * n3;
        n3 = n2 / 10;
        byArray[2] = (byte)(48 + n3);
        byArray[3] = (byte)(48 + (n2 - 10 * n3));
        byArray[4] = 45;
        DefaultLogger.zeroPad(localDateTime.getMonthValue(), byArray, 5);
        byArray[7] = 45;
        DefaultLogger.zeroPad(localDateTime.getDayOfMonth(), byArray, 8);
        byArray[10] = 32;
        DefaultLogger.zeroPad(localDateTime.getHour(), byArray, 11);
        byArray[13] = 58;
        DefaultLogger.zeroPad(localDateTime.getMinute(), byArray, 14);
        byArray[16] = 58;
        DefaultLogger.zeroPad(localDateTime.getSecond(), byArray, 17);
        byArray[19] = 46;
        int n4 = localDateTime.get(ChronoField.MILLI_OF_SECOND);
        n3 = n4 / 100;
        byArray[20] = (byte)(48 + n3);
        n4 -= 100 * n3;
        n3 = n4 / 10;
        byArray[21] = (byte)(48 + n3);
        byArray[22] = (byte)(48 + (n4 - 10 * n3));
        return new String(byArray, StandardCharsets.UTF_8);
    }

    void writeWithThrowable(StringBuilder stringBuilder, Throwable throwable) {
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            try (PrintWriter printWriter = new PrintWriter(stringWriter);){
                throwable.printStackTrace(printWriter);
                stringBuilder.append(stringWriter);
            }
        }
        this.logLocation.print(stringBuilder.toString());
    }

    private static void zeroPad(int n2, byte[] byArray, int n3) {
        if (n2 < 10) {
            byArray[n3++] = 48;
            byArray[n3] = (byte)(48 + n2);
        } else {
            int n4 = n2 / 10;
            byArray[n3++] = (byte)(48 + n4);
            byArray[n3] = (byte)(48 + (n2 - 10 * n4));
        }
    }
}

