/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.JacksonDatabind212;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.JacksonVersion;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.MemberNameConverter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonGetter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonIgnore;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonProperty;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ObjectMapper;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializationConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.PackageVersion;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.BeanUtil;

final class MemberNameConverterImpl
implements MemberNameConverter {
    private static final ClientLogger LOGGER = new ClientLogger(MemberNameConverterImpl.class);
    private final ObjectMapper mapper;
    final boolean useJackson212;
    private boolean jackson212IsSafe = true;

    MemberNameConverterImpl(ObjectMapper objectMapper) {
        this.mapper = objectMapper;
        this.useJackson212 = PackageVersion.VERSION.getMinorVersion() >= 12;
    }

    @Override
    public String convertMemberName(Member member) {
        if (Modifier.isTransient(member.getModifiers())) {
            return null;
        }
        VisibilityChecker<?> visibilityChecker = this.mapper.getVisibilityChecker();
        if (member instanceof Field) {
            Field field = (Field)member;
            if (field.isAnnotationPresent(JsonIgnore.class) || !visibilityChecker.isFieldVisible(field)) {
                if (field.isAnnotationPresent(JsonProperty.class)) {
                    LOGGER.atInfo().addKeyValue("field", field.getName()).log("Field is annotated with JsonProperty but isn't accessible to JacksonJsonSerializer.");
                }
                return null;
            }
            if (field.isAnnotationPresent(JsonProperty.class)) {
                String string = field.getDeclaredAnnotation(JsonProperty.class).value();
                return CoreUtils.isNullOrEmpty(string) ? field.getName() : string;
            }
            return field.getName();
        }
        if (member instanceof Method) {
            Method method = (Method)member;
            if (!MemberNameConverterImpl.verifyGetter(method) || method.isAnnotationPresent(JsonIgnore.class) || !visibilityChecker.isGetterVisible(method)) {
                if (method.isAnnotationPresent(JsonGetter.class) || method.isAnnotationPresent(JsonProperty.class)) {
                    LOGGER.atInfo().addKeyValue("method", method.getName()).log("Method is annotated with either JsonGetter or JsonProperty but isn't accessible to JacksonJsonSerializer.");
                }
                return null;
            }
            String string = this.removePrefix(method);
            if (method.isAnnotationPresent(JsonGetter.class)) {
                String string2 = method.getDeclaredAnnotation(JsonGetter.class).value();
                return CoreUtils.isNullOrEmpty(string2) ? string : string2;
            }
            if (method.isAnnotationPresent(JsonProperty.class)) {
                String string3 = method.getDeclaredAnnotation(JsonProperty.class).value();
                return CoreUtils.isNullOrEmpty(string3) ? string : string3;
            }
            return string;
        }
        return null;
    }

    private static boolean verifyGetter(Method method) {
        Class<?> clazz = method.getReturnType();
        return method.getParameterCount() == 0 && clazz != Void.TYPE && clazz != Void.class;
    }

    private String removePrefix(Method method) {
        SerializationConfig serializationConfig = this.mapper.getSerializationConfig();
        AnnotatedClass annotatedClass = AnnotatedClassResolver.resolve(serializationConfig, this.mapper.constructType(method.getDeclaringClass()), null);
        AnnotatedMethod annotatedMethod = annotatedClass.findMethod(method.getName(), method.getParameterTypes());
        String string = annotatedMethod.getName();
        String string2 = null;
        if (this.useJackson212 && this.jackson212IsSafe) {
            try {
                string2 = JacksonDatabind212.removePrefix(serializationConfig, annotatedClass, annotatedMethod, string);
            }
            catch (Throwable throwable) {
                if (throwable instanceof LinkageError) {
                    this.jackson212IsSafe = false;
                    LOGGER.log(LogLevel.VERBOSE, JacksonVersion::getHelpInfo, throwable);
                }
                throw throwable;
            }
        }
        if (string2 == null) {
            string2 = MemberNameConverterImpl.removePrefixWithBeanUtils(annotatedMethod);
        }
        return string2;
    }

    private static String removePrefixWithBeanUtils(AnnotatedMethod annotatedMethod) {
        return BeanUtil.okNameForGetter(annotatedMethod, false);
    }
}

