/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson;

import java.io.IOException;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.AzureJsonUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;

final class JacksonJsonReader
extends JsonReader {
    private static final ClientLogger LOGGER = new ClientLogger(JacksonJsonReader.class);
    private final JsonParser parser;
    private final byte[] jsonBytes;
    private final String jsonString;
    private final boolean resetSupported;
    private final JsonOptions jsonOptions;
    private JsonToken currentToken;

    JacksonJsonReader(JsonParser jsonParser, byte[] byArray, String string, boolean bl2, JsonOptions jsonOptions) {
        this.parser = Objects.requireNonNull(jsonParser, "Cannot create a Jackson-based instance of macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader with a null Jackson JsonParser.");
        this.jsonBytes = byArray;
        this.jsonString = string;
        this.resetSupported = bl2;
        this.jsonOptions = jsonOptions;
        this.currentToken = JacksonJsonReader.mapToken(jsonParser.currentToken(), null);
    }

    @Override
    public JsonToken currentToken() {
        return this.currentToken;
    }

    @Override
    public JsonToken nextToken() throws IOException {
        this.currentToken = JacksonJsonReader.mapToken(this.parser.nextToken(), this.currentToken);
        return this.currentToken;
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
    }

    @Override
    public byte[] getBinary() throws IOException {
        if (this.currentToken() == JsonToken.NULL) {
            return null;
        }
        return this.parser.getBinaryValue();
    }

    @Override
    public boolean getBoolean() throws IOException {
        return this.parser.getBooleanValue();
    }

    @Override
    public float getFloat() throws IOException {
        return this.parser.getFloatValue();
    }

    @Override
    public double getDouble() throws IOException {
        return this.parser.getDoubleValue();
    }

    @Override
    public int getInt() throws IOException {
        return this.parser.getIntValue();
    }

    @Override
    public long getLong() throws IOException {
        return this.parser.getLongValue();
    }

    @Override
    public String getString() throws IOException {
        return this.parser.getValueAsString();
    }

    @Override
    public String getFieldName() throws IOException {
        return this.parser.currentName();
    }

    @Override
    public void skipChildren() throws IOException {
        this.parser.skipChildren();
    }

    @Override
    public JsonReader bufferObject() throws IOException {
        JsonToken jsonToken = this.currentToken();
        if (jsonToken == JsonToken.START_OBJECT || jsonToken == JsonToken.FIELD_NAME) {
            String string = this.readRemainingFieldsAsJsonObject();
            return AzureJsonUtils.createReader(string, this.jsonOptions);
        }
        throw LOGGER.logExceptionAsError(new IllegalStateException("Cannot buffer a JSON object from a non-object, non-field name starting location. Starting location: " + (Object)((Object)this.currentToken())));
    }

    @Override
    public boolean isResetSupported() {
        return this.resetSupported;
    }

    @Override
    public JsonReader reset() throws IOException {
        if (!this.resetSupported) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("'reset' isn't supported by this JsonReader."));
        }
        return this.jsonBytes != null ? AzureJsonUtils.createReader(this.jsonBytes, this.jsonOptions) : AzureJsonUtils.createReader(this.jsonString, this.jsonOptions);
    }

    private static JsonToken mapToken(macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonToken jsonToken, JsonToken jsonToken2) {
        if (jsonToken == null && jsonToken2 == null) {
            return null;
        }
        if (jsonToken == null) {
            return JsonToken.END_DOCUMENT;
        }
        switch (jsonToken) {
            case START_OBJECT: {
                return JsonToken.START_OBJECT;
            }
            case END_OBJECT: {
                return JsonToken.END_OBJECT;
            }
            case START_ARRAY: {
                return JsonToken.START_ARRAY;
            }
            case END_ARRAY: {
                return JsonToken.END_ARRAY;
            }
            case FIELD_NAME: {
                return JsonToken.FIELD_NAME;
            }
            case VALUE_STRING: {
                return JsonToken.STRING;
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return JsonToken.NUMBER;
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                return JsonToken.BOOLEAN;
            }
            case VALUE_NULL: {
                return JsonToken.NULL;
            }
        }
        throw LOGGER.logExceptionAsError(new IllegalStateException("Unsupported token type: '" + (Object)((Object)jsonToken) + "'."));
    }
}

