/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoBoundingBox;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoCollection;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoLineString;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoLineStringCollection;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoLinearRing;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoObject;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoObjectType;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPoint;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPointCollection;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPolygon;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPolygonCollection;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPosition;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.module.SimpleModule;

final class GeoJsonDeserializer
extends JsonDeserializer<GeoObject> {
    private static final ClientLogger LOGGER = new ClientLogger(GeoJsonDeserializer.class);
    static final String TYPE_PROPERTY = "type";
    static final String GEOMETRIES_PROPERTY = "geometries";
    static final String COORDINATES_PROPERTY = "coordinates";
    static final String BOUNDING_BOX_PROPERTY = "bbox";
    static final SimpleModule MODULE = new SimpleModule().addDeserializer(GeoObject.class, new GeoJsonDeserializer()).addDeserializer(GeoPoint.class, GeoJsonDeserializer.geoSubclassDeserializer(GeoPoint.class)).addDeserializer(GeoLineString.class, GeoJsonDeserializer.geoSubclassDeserializer(GeoLineString.class)).addDeserializer(GeoPolygon.class, GeoJsonDeserializer.geoSubclassDeserializer(GeoPolygon.class)).addDeserializer(GeoPointCollection.class, GeoJsonDeserializer.geoSubclassDeserializer(GeoPointCollection.class)).addDeserializer(GeoLineStringCollection.class, GeoJsonDeserializer.geoSubclassDeserializer(GeoLineStringCollection.class)).addDeserializer(GeoPolygonCollection.class, GeoJsonDeserializer.geoSubclassDeserializer(GeoPolygonCollection.class)).addDeserializer(GeoCollection.class, GeoJsonDeserializer.geoSubclassDeserializer(GeoCollection.class));

    GeoJsonDeserializer() {
    }

    public static SimpleModule getModule() {
        return MODULE;
    }

    @Override
    public GeoObject deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return GeoJsonDeserializer.read(deserializationContext.readTree(jsonParser));
    }

    private static GeoObject read(JsonNode jsonNode2) {
        String string = GeoJsonDeserializer.getRequiredProperty(jsonNode2, TYPE_PROPERTY).asText();
        if (GeoJsonDeserializer.isGeoObjectType(string, GeoObjectType.GEOMETRY_COLLECTION)) {
            ArrayList<GeoObject> arrayList = new ArrayList<GeoObject>();
            for (JsonNode jsonNode3 : GeoJsonDeserializer.getRequiredProperty(jsonNode2, GEOMETRIES_PROPERTY)) {
                arrayList.add(GeoJsonDeserializer.read(jsonNode3));
            }
            return new GeoCollection(arrayList, GeoJsonDeserializer.readBoundingBox(jsonNode2), GeoJsonDeserializer.readProperties(jsonNode2, GEOMETRIES_PROPERTY));
        }
        JsonNode jsonNode4 = GeoJsonDeserializer.getRequiredProperty(jsonNode2, COORDINATES_PROPERTY);
        GeoBoundingBox geoBoundingBox = GeoJsonDeserializer.readBoundingBox(jsonNode2);
        Map<String, Object> map = GeoJsonDeserializer.readProperties(jsonNode2);
        if (GeoJsonDeserializer.isGeoObjectType(string, GeoObjectType.POINT)) {
            return new GeoPoint(GeoJsonDeserializer.readCoordinate(jsonNode4), geoBoundingBox, map);
        }
        if (GeoJsonDeserializer.isGeoObjectType(string, GeoObjectType.LINE_STRING)) {
            return new GeoLineString(GeoJsonDeserializer.readCoordinates(jsonNode4), geoBoundingBox, map);
        }
        if (GeoJsonDeserializer.isGeoObjectType(string, GeoObjectType.POLYGON)) {
            ArrayList<GeoLinearRing> arrayList = new ArrayList<GeoLinearRing>();
            jsonNode4.forEach(jsonNode -> arrayList.add(new GeoLinearRing(GeoJsonDeserializer.readCoordinates(jsonNode))));
            return new GeoPolygon(arrayList, geoBoundingBox, map);
        }
        if (GeoJsonDeserializer.isGeoObjectType(string, GeoObjectType.MULTI_POINT)) {
            ArrayList<GeoPoint> arrayList = new ArrayList<GeoPoint>();
            GeoJsonDeserializer.readCoordinates(jsonNode4).forEach(geoPosition -> arrayList.add(new GeoPoint((GeoPosition)geoPosition)));
            return new GeoPointCollection(arrayList, geoBoundingBox, map);
        }
        if (GeoJsonDeserializer.isGeoObjectType(string, GeoObjectType.MULTI_LINE_STRING)) {
            ArrayList<GeoLineString> arrayList = new ArrayList<GeoLineString>();
            jsonNode4.forEach(jsonNode -> arrayList.add(new GeoLineString(GeoJsonDeserializer.readCoordinates(jsonNode))));
            return new GeoLineStringCollection(arrayList, geoBoundingBox, map);
        }
        if (GeoJsonDeserializer.isGeoObjectType(string, GeoObjectType.MULTI_POLYGON)) {
            return GeoJsonDeserializer.readMultiPolygon(jsonNode4, geoBoundingBox, map);
        }
        throw LOGGER.logExceptionAsError(new IllegalStateException(String.format("Unsupported geo type %s.", string)));
    }

    private static boolean isGeoObjectType(String string, GeoObjectType geoObjectType) {
        return geoObjectType.toString().equalsIgnoreCase(string);
    }

    private static GeoPolygonCollection readMultiPolygon(JsonNode jsonNode2, GeoBoundingBox geoBoundingBox, Map<String, Object> map) {
        ArrayList<GeoPolygon> arrayList = new ArrayList<GeoPolygon>();
        for (JsonNode jsonNode3 : jsonNode2) {
            ArrayList<GeoLinearRing> arrayList2 = new ArrayList<GeoLinearRing>();
            jsonNode3.forEach(jsonNode -> arrayList2.add(new GeoLinearRing(GeoJsonDeserializer.readCoordinates(jsonNode))));
            arrayList.add(new GeoPolygon(arrayList2));
        }
        return new GeoPolygonCollection(arrayList, geoBoundingBox, map);
    }

    private static JsonNode getRequiredProperty(JsonNode jsonNode, String string) {
        JsonNode jsonNode2 = jsonNode.get(string);
        if (jsonNode2 == null) {
            throw LOGGER.logExceptionAsError(new IllegalStateException(String.format("GeoJSON object expected to have '%s' property.", string)));
        }
        return jsonNode2;
    }

    private static GeoBoundingBox readBoundingBox(JsonNode jsonNode) {
        JsonNode jsonNode2 = jsonNode.get(BOUNDING_BOX_PROPERTY);
        if (jsonNode2 != null) {
            switch (jsonNode2.size()) {
                case 4: {
                    return new GeoBoundingBox(jsonNode2.get(0).asDouble(), jsonNode2.get(1).asDouble(), jsonNode2.get(2).asDouble(), jsonNode2.get(3).asDouble());
                }
                case 6: {
                    return new GeoBoundingBox(jsonNode2.get(0).asDouble(), jsonNode2.get(1).asDouble(), jsonNode2.get(3).asDouble(), jsonNode2.get(4).asDouble(), jsonNode2.get(2).asDouble(), jsonNode2.get(5).asDouble());
                }
            }
            throw LOGGER.logExceptionAsError(new IllegalStateException("Only 2 or 3 dimension bounding boxes are supported."));
        }
        return null;
    }

    private static Map<String, Object> readProperties(JsonNode jsonNode) {
        return GeoJsonDeserializer.readProperties(jsonNode, COORDINATES_PROPERTY);
    }

    private static Map<String, Object> readProperties(JsonNode jsonNode, String string) {
        HashMap<String, Object> hashMap = null;
        Iterator<Map.Entry<String, JsonNode>> iterator = jsonNode.fields();
        while (iterator.hasNext()) {
            Map.Entry<String, JsonNode> entry = iterator.next();
            String string2 = entry.getKey();
            if (string2.equalsIgnoreCase(TYPE_PROPERTY) || string2.equalsIgnoreCase(BOUNDING_BOX_PROPERTY) || string2.equalsIgnoreCase(string)) continue;
            if (hashMap == null) {
                hashMap = new HashMap<String, Object>();
            }
            hashMap.put(string2, GeoJsonDeserializer.readAdditionalPropertyValue(entry.getValue()));
        }
        return hashMap;
    }

    private static Object readAdditionalPropertyValue(JsonNode jsonNode2) {
        switch (jsonNode2.getNodeType()) {
            case STRING: {
                return jsonNode2.asText();
            }
            case NUMBER: {
                if (jsonNode2.isInt()) {
                    return jsonNode2.asInt();
                }
                if (jsonNode2.isLong()) {
                    return jsonNode2.asLong();
                }
                if (jsonNode2.isFloat()) {
                    return Float.valueOf(jsonNode2.floatValue());
                }
                return jsonNode2.asDouble();
            }
            case BOOLEAN: {
                return jsonNode2.asBoolean();
            }
            case NULL: 
            case MISSING: {
                return null;
            }
            case OBJECT: {
                HashMap hashMap = new HashMap();
                jsonNode2.fields().forEachRemaining(entry -> hashMap.put((String)entry.getKey(), GeoJsonDeserializer.readAdditionalPropertyValue((JsonNode)entry.getValue())));
                return hashMap;
            }
            case ARRAY: {
                ArrayList arrayList = new ArrayList();
                jsonNode2.forEach(jsonNode -> arrayList.add(GeoJsonDeserializer.readAdditionalPropertyValue(jsonNode)));
                return arrayList;
            }
        }
        throw LOGGER.logExceptionAsError(new IllegalStateException(String.format("Unsupported additional property type %s.", new Object[]{jsonNode2.getNodeType()})));
    }

    private static List<GeoPosition> readCoordinates(JsonNode jsonNode2) {
        ArrayList<GeoPosition> arrayList = new ArrayList<GeoPosition>();
        jsonNode2.forEach(jsonNode -> arrayList.add(GeoJsonDeserializer.readCoordinate(jsonNode)));
        return arrayList;
    }

    private static GeoPosition readCoordinate(JsonNode jsonNode) {
        int n2 = jsonNode.size();
        if (n2 < 2 || n2 > 3) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("Only 2 or 3 element coordinates supported."));
        }
        double d2 = jsonNode.get(0).asDouble();
        double d3 = jsonNode.get(1).asDouble();
        Double d4 = null;
        if (n2 > 2) {
            d4 = jsonNode.get(2).asDouble();
        }
        return new GeoPosition(d2, d3, d4);
    }

    private static <T extends GeoObject> JsonDeserializer<T> geoSubclassDeserializer(final Class<T> clazz) {
        return new JsonDeserializer<T>(){

            @Override
            public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                return (GeoObject)clazz.cast(GeoJsonDeserializer.read(deserializationContext.readTree(jsonParser)));
            }
        };
    }
}

