/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson;

import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializationFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializerProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.module.SimpleModule;

final class DateTimeSerializer
extends JsonSerializer<OffsetDateTime> {
    private static final SimpleModule MODULE = new SimpleModule().addSerializer(OffsetDateTime.class, new DateTimeSerializer());

    DateTimeSerializer() {
    }

    public static SimpleModule getModule() {
        return MODULE;
    }

    @Override
    public void serialize(OffsetDateTime offsetDateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jsonGenerator.writeNumber(offsetDateTime.toInstant().toEpochMilli());
        } else {
            jsonGenerator.writeString(DateTimeSerializer.toString(offsetDateTime));
        }
    }

    public static String toString(OffsetDateTime offsetDateTime) {
        String string = null;
        if (offsetDateTime != null && (string = DateTimeFormatter.ISO_INSTANT.format(offsetDateTime = offsetDateTime.withOffsetSameInstant(ZoneOffset.UTC))).startsWith("+")) {
            string = string.substring(1);
        }
        return string;
    }
}

