/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson;

import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.module.SimpleModule;

class DateTimeDeserializer
extends JsonDeserializer<OffsetDateTime> {
    private static final SimpleModule MODULE = new SimpleModule().addDeserializer(OffsetDateTime.class, new DateTimeDeserializer());

    DateTimeDeserializer() {
    }

    public static SimpleModule getModule() {
        return MODULE;
    }

    @Override
    public OffsetDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            return OffsetDateTime.ofInstant(Instant.ofEpochSecond(jsonParser.getValueAsLong()), ZoneOffset.UTC);
        }
        TemporalAccessor temporalAccessor = DateTimeFormatter.ISO_DATE_TIME.parseBest(jsonParser.getValueAsString(), OffsetDateTime::from, LocalDateTime::from);
        if (temporalAccessor.query(TemporalQueries.offset()) == null) {
            return LocalDateTime.from(temporalAccessor).atOffset(ZoneOffset.UTC);
        }
        return OffsetDateTime.from(temporalAccessor);
    }
}

