/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest;

import com.azure.xml.XmlSerializable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.function.Consumer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipeline;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.RequestOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.Response;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.StreamResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ImplUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectionSerializable;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.TypeUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.ErrorOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.RequestDataConfiguration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.RestProxyBase;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.RestProxyUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.SwaggerInterfaceParser;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.SwaggerMethodParser;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.serializer.HttpResponseDecoder;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Base64Url;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.BinaryData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Context;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.SerializerAdapter;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.SerializerEncoding;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonSerializable;

public class SyncRestProxy
extends RestProxyBase {
    public SyncRestProxy(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, SwaggerInterfaceParser swaggerInterfaceParser) {
        super(httpPipeline, serializerAdapter, swaggerInterfaceParser);
    }

    HttpResponse send(HttpRequest httpRequest, Context context) {
        return this.httpPipeline.sendSync(httpRequest, context);
    }

    @Override
    public Object invoke(Object object, Method method, RequestOptions requestOptions, EnumSet<ErrorOptions> enumSet, Consumer<HttpRequest> consumer, SwaggerMethodParser swaggerMethodParser, HttpRequest httpRequest, Context context) {
        Object object2;
        block10: {
            HttpResponseDecoder.HttpDecodedResponse httpDecodedResponse = null;
            context = this.startTracingSpan(swaggerMethodParser, context);
            AutoCloseable autoCloseable = this.tracer.makeSpanCurrent(context);
            try {
                if (requestOptions != null && consumer != null) {
                    consumer.accept(httpRequest);
                }
                if (httpRequest.getBodyAsBinaryData() != null) {
                    httpRequest.setBody(RestProxyUtils.validateLengthSync(httpRequest));
                }
                HttpResponse httpResponse = this.send(httpRequest, context);
                httpDecodedResponse = this.decoder.decodeSync(httpResponse, swaggerMethodParser);
                Object object3 = this.handleRestReturnType(httpDecodedResponse, swaggerMethodParser, swaggerMethodParser.getReturnType(), context, requestOptions, enumSet);
                int n2 = httpDecodedResponse.getSourceResponse().getStatusCode();
                this.tracer.end(n2 >= 400 ? String.valueOf(n2) : null, null, context);
                object2 = object3;
                if (autoCloseable == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (autoCloseable != null) {
                        try {
                            autoCloseable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    this.tracer.end(null, (Throwable)exception, context);
                    ImplUtils.sneakyThrows(exception);
                    return null;
                }
            }
            autoCloseable.close();
        }
        return object2;
    }

    private HttpResponseDecoder.HttpDecodedResponse ensureExpectedStatus(HttpResponseDecoder.HttpDecodedResponse httpDecodedResponse, SwaggerMethodParser swaggerMethodParser, RequestOptions requestOptions, EnumSet<ErrorOptions> enumSet) {
        byte[] byArray;
        int n2 = httpDecodedResponse.getSourceResponse().getStatusCode();
        if (swaggerMethodParser.isExpectedResponseStatusCode(n2) || requestOptions != null && enumSet.contains((Object)ErrorOptions.NO_THROW)) {
            return httpDecodedResponse;
        }
        BinaryData binaryData = httpDecodedResponse.getSourceResponse().getBodyAsBinaryData();
        byte[] byArray2 = byArray = binaryData == null ? null : binaryData.toBytes();
        if (byArray == null || byArray.length == 0) {
            throw SyncRestProxy.instantiateUnexpectedException(swaggerMethodParser.getUnexpectedException(n2), httpDecodedResponse.getSourceResponse(), null, null);
        }
        Object object = httpDecodedResponse.getDecodedBody(byArray);
        throw SyncRestProxy.instantiateUnexpectedException(swaggerMethodParser.getUnexpectedException(n2), httpDecodedResponse.getSourceResponse(), byArray, object);
    }

    private Object handleRestResponseReturnType(HttpResponseDecoder.HttpDecodedResponse httpDecodedResponse, SwaggerMethodParser swaggerMethodParser, Type type) {
        if (swaggerMethodParser.isStreamResponse()) {
            return new StreamResponse(httpDecodedResponse.getSourceResponse());
        }
        if (TypeUtil.isTypeOrSubTypeOf(type, Response.class)) {
            Type type2 = TypeUtil.getRestResponseBodyType(type);
            if (TypeUtil.isTypeOrSubTypeOf(type2, Void.class)) {
                httpDecodedResponse.getSourceResponse().close();
                return this.createResponse(httpDecodedResponse, type, null);
            }
            Object object = this.handleBodyReturnType(httpDecodedResponse, swaggerMethodParser, type2);
            Response response = this.createResponse(httpDecodedResponse, type, object);
            if (response == null) {
                return this.createResponse(httpDecodedResponse, type, null);
            }
            return response;
        }
        return this.handleBodyReturnType(httpDecodedResponse, swaggerMethodParser, type);
    }

    private Object handleBodyReturnType(HttpResponseDecoder.HttpDecodedResponse httpDecodedResponse, SwaggerMethodParser swaggerMethodParser, Type type) {
        Object object;
        int n2 = httpDecodedResponse.getSourceResponse().getStatusCode();
        HttpMethod httpMethod = swaggerMethodParser.getHttpMethod();
        Type type2 = swaggerMethodParser.getReturnValueWireType();
        if (httpMethod == HttpMethod.HEAD && (TypeUtil.isTypeOrSubTypeOf(type, Boolean.TYPE) || TypeUtil.isTypeOrSubTypeOf(type, Boolean.class))) {
            object = Boolean.valueOf(n2 / 100 == 2);
        } else if (TypeUtil.isTypeOrSubTypeOf(type, byte[].class)) {
            byte[] byArray;
            BinaryData binaryData = httpDecodedResponse.getSourceResponse().getBodyAsBinaryData();
            byte[] byArray2 = byArray = binaryData != null ? binaryData.toBytes() : null;
            if (type2 == Base64Url.class) {
                byArray = new Base64Url(byArray).decodedBytes();
            }
            object = byArray != null ? (byArray.length == 0 ? null : byArray) : null;
        } else {
            object = TypeUtil.isTypeOrSubTypeOf(type, InputStream.class) ? httpDecodedResponse.getSourceResponse().getBodyAsInputStream() : (TypeUtil.isTypeOrSubTypeOf(type, BinaryData.class) ? httpDecodedResponse.getSourceResponse().getBodyAsBinaryData() : httpDecodedResponse.getDecodedBody(null));
        }
        return object;
    }

    private Object handleRestReturnType(HttpResponseDecoder.HttpDecodedResponse httpDecodedResponse, SwaggerMethodParser swaggerMethodParser, Type type, Context context, RequestOptions requestOptions, EnumSet<ErrorOptions> enumSet) {
        Object object;
        HttpResponseDecoder.HttpDecodedResponse httpDecodedResponse2 = this.ensureExpectedStatus(httpDecodedResponse, swaggerMethodParser, requestOptions, enumSet);
        if (TypeUtil.isTypeOrSubTypeOf(type, Void.TYPE) || TypeUtil.isTypeOrSubTypeOf(type, Void.class)) {
            httpDecodedResponse2.close();
            object = null;
        } else {
            object = this.handleRestResponseReturnType(httpDecodedResponse, swaggerMethodParser, type);
        }
        return object;
    }

    @Override
    public void updateRequest(RequestDataConfiguration requestDataConfiguration, SerializerAdapter serializerAdapter) throws IOException {
        boolean bl2 = requestDataConfiguration.isJson();
        HttpRequest httpRequest = requestDataConfiguration.getHttpRequest();
        Object object = requestDataConfiguration.getBodyContent();
        if (object == null) {
            return;
        }
        if (ReflectionSerializable.supportsJsonSerializable(object.getClass())) {
            httpRequest.setBody(ReflectionSerializable.serializeJsonSerializableToBytes((JsonSerializable)object));
            return;
        }
        if (ReflectionSerializable.supportsXmlSerializable(object.getClass())) {
            httpRequest.setBody(ReflectionSerializable.serializeXmlSerializableToBytes((XmlSerializable)object));
            return;
        }
        if (bl2) {
            httpRequest.setBody(serializerAdapter.serializeToBytes(object, SerializerEncoding.JSON));
        } else if (object instanceof byte[]) {
            httpRequest.setBody((byte[])object);
        } else if (object instanceof String) {
            String string = (String)object;
            if (!string.isEmpty()) {
                httpRequest.setBody(string);
            }
        } else if (object instanceof ByteBuffer) {
            httpRequest.setBody(BinaryData.fromByteBuffer((ByteBuffer)object));
        } else if (object instanceof InputStream) {
            httpRequest.setBody(BinaryData.fromStream((InputStream)object));
        } else {
            SerializerEncoding serializerEncoding = SerializerEncoding.fromHeaders(httpRequest.getHeaders());
            httpRequest.setBody(serializerAdapter.serializeToBytes(object, serializerEncoding));
        }
    }
}

