/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.UnexpectedLengthException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

final class LengthValidatingInputStream
extends InputStream {
    private static final ClientLogger LOGGER = new ClientLogger(LengthValidatingInputStream.class);
    private final InputStream inner;
    private final long expectedReadSize;
    private long position;
    private long mark = -1L;

    LengthValidatingInputStream(InputStream inputStream, long l2) {
        this.inner = Objects.requireNonNull(inputStream, "'inputStream' cannot be null.");
        if (l2 < 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'expectedReadSize' cannot be less than 0."));
        }
        this.expectedReadSize = l2;
    }

    @Override
    public synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = 0;
        do {
            n4 = this.inner.read(byArray, n2 + n5, n3 - n5);
            this.validateLength(n4);
            if (n4 != -1) {
                n5 += n4;
                continue;
            }
            if (n5 != 0) continue;
            n5 = -1;
        } while (n4 != -1 && n5 != n3);
        return n5;
    }

    @Override
    public synchronized long skip(long l2) throws IOException {
        long l3 = this.inner.skip(l2);
        this.position += l3;
        return l3;
    }

    @Override
    public int available() throws IOException {
        return this.inner.available();
    }

    @Override
    public void close() throws IOException {
        this.inner.close();
    }

    @Override
    public synchronized void mark(int n2) {
        this.inner.mark(n2);
        this.mark = this.position;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inner.reset();
        this.position = this.mark;
    }

    @Override
    public boolean markSupported() {
        return this.inner.markSupported();
    }

    @Override
    public synchronized int read() throws IOException {
        int n2 = this.inner.read();
        this.validateLength(n2 == -1 ? -1 : 1);
        return n2;
    }

    private void validateLength(int n2) {
        if (n2 == -1) {
            if (this.position > this.expectedReadSize) {
                throw LOGGER.logExceptionAsError(new UnexpectedLengthException(String.format("Request body emitted %d bytes, more than the expected %d bytes.", this.position, this.expectedReadSize), this.position, this.expectedReadSize));
            }
            if (this.position < this.expectedReadSize) {
                throw LOGGER.logExceptionAsError(new UnexpectedLengthException(String.format("Request body emitted %d bytes, less than the expected %d bytes.", this.position, this.expectedReadSize), this.position, this.expectedReadSize));
            }
        } else {
            this.position += (long)n2;
        }
    }
}

