/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http;

import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipeline;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineCallContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelinePolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public class HttpPipelineCallState {
    private static final ClientLogger LOGGER = new ClientLogger(HttpPipelineCallState.class);
    private final HttpPipeline pipeline;
    private final HttpPipelineCallContext callContext;
    private int currentPolicyIndex;

    public HttpPipelineCallState(HttpPipeline httpPipeline, HttpPipelineCallContext httpPipelineCallContext) {
        this.pipeline = httpPipeline;
        this.callContext = httpPipelineCallContext;
        this.currentPolicyIndex = -1;
    }

    public HttpPipelinePolicy getNextPolicy() {
        int n2 = this.pipeline.getPolicyCount();
        ++this.currentPolicyIndex;
        if (this.currentPolicyIndex > n2) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("There is no more policies to execute."));
        }
        if (this.currentPolicyIndex == n2) {
            return null;
        }
        return this.pipeline.getPolicy(this.currentPolicyIndex);
    }

    public HttpPipeline getPipeline() {
        return this.pipeline;
    }

    public HttpPipelinePolicy getCurrentPolicy() {
        return this.pipeline.getPolicy(this.currentPolicyIndex);
    }

    public HttpPipelineCallContext getCallContext() {
        return this.callContext;
    }

    public HttpPipelineCallState clone() {
        HttpPipelineCallState httpPipelineCallState = new HttpPipelineCallState(this.pipeline, this.callContext);
        httpPipelineCallState.currentPolicyIndex = this.currentPolicyIndex;
        return httpPipelineCallState;
    }
}

