/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.RetryOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.RetryStrategy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ImplUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;
import macromedia.jdbc.sqlserver.externals.reactor.core.CoreSubscriber;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;

public final class RetriableDownloadFlux
extends Flux<ByteBuffer> {
    private static final ClientLogger LOGGER = new ClientLogger(RetriableDownloadFlux.class);
    private final Supplier<Flux<ByteBuffer>> downloadSupplier;
    private final BiFunction<Throwable, Long, Flux<ByteBuffer>> onDownloadErrorResume;
    private final RetryStrategy retryStrategy;
    private final int maxRetries;
    private final long position;
    private final int retryCount;

    public RetriableDownloadFlux(Supplier<Flux<ByteBuffer>> supplier, BiFunction<Throwable, Long, Flux<ByteBuffer>> biFunction, RetryOptions retryOptions, long l2) {
        this(supplier, biFunction, ImplUtils.getRetryStrategyFromOptions(retryOptions), l2, 0);
    }

    private RetriableDownloadFlux(Supplier<Flux<ByteBuffer>> supplier, BiFunction<Throwable, Long, Flux<ByteBuffer>> biFunction, RetryStrategy retryStrategy, long l2, int n2) {
        this.downloadSupplier = supplier;
        this.onDownloadErrorResume = biFunction;
        this.retryStrategy = retryStrategy;
        this.maxRetries = retryStrategy.getMaxRetries();
        this.position = l2;
        this.retryCount = n2;
    }

    public void subscribe(CoreSubscriber<? super ByteBuffer> coreSubscriber) {
        long[] lArray = new long[]{this.position};
        this.downloadSupplier.get().map(byteBuffer -> {
            lArray[0] = lArray[0] + (long)byteBuffer.remaining();
            return byteBuffer;
        }).onErrorResume(Exception.class, exception -> {
            int n2 = this.retryCount + 1;
            if (n2 > this.maxRetries) {
                LOGGER.log(LogLevel.ERROR, () -> "Exhausted all retry attempts while downloading, " + this.maxRetries + " of " + this.maxRetries + ".", (Throwable)exception);
                return Flux.error((Throwable)exception);
            }
            LOGGER.log(LogLevel.INFORMATIONAL, () -> "Using retry attempt " + n2 + " of " + this.maxRetries + " while downloading.", (Throwable)exception);
            Duration duration = this.retryStrategy.calculateRetryDelay(n2);
            RetriableDownloadFlux retriableDownloadFlux = new RetriableDownloadFlux(() -> this.onDownloadErrorResume.apply((Throwable)exception, lArray[0]), this.onDownloadErrorResume, this.retryStrategy, lArray[0], n2);
            if (duration != null && !duration.isNegative() && !duration.isZero()) {
                return retriableDownloadFlux.delaySubscription(duration);
            }
            return retriableDownloadFlux;
        }).subscribe(coreSubscriber);
    }
}

