/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ImplUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.org.reactivestreams.Subscriber;
import macromedia.jdbc.sqlserver.externals.org.reactivestreams.Subscription;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.MonoSink;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Operators;

public final class OutputStreamWriteSubscriber
implements Subscriber<ByteBuffer> {
    private final MonoSink<Void> emitter;
    private final OutputStream stream;
    private final ClientLogger logger;
    private Subscription subscription;

    public OutputStreamWriteSubscriber(MonoSink<Void> monoSink, OutputStream outputStream, ClientLogger clientLogger) {
        this.emitter = monoSink;
        this.stream = outputStream;
        this.logger = clientLogger;
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        if (Operators.validate((Subscription)this.subscription, (Subscription)subscription)) {
            this.subscription = subscription;
            subscription.request(1L);
        }
    }

    @Override
    public void onNext(ByteBuffer byteBuffer) {
        try {
            ImplUtils.writeByteBufferToStream(byteBuffer, this.stream);
            this.subscription.request(1L);
        }
        catch (IOException iOException) {
            this.onError(new UncheckedIOException(iOException));
        }
    }

    @Override
    public void onError(Throwable throwable) {
        this.subscription.cancel();
        this.emitter.error(this.logger.logThrowableAsError(throwable));
    }

    @Override
    public void onComplete() {
        this.emitter.success();
    }
}

