/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation;

import java.util.NoSuchElementException;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public final class Option<T> {
    private static final ClientLogger LOGGER = new ClientLogger(Option.class);
    private static final Option<?> UNINITIALIZED = new Option();
    private static final Option<?> EMPTY = new Option<Object>(null);
    private final boolean isInitialized;
    private final T value;

    public static <T> Option<T> of(T t2) {
        return t2 == null ? Option.empty() : new Option<T>(t2);
    }

    public static <T> Option<T> empty() {
        Option<?> option = EMPTY;
        return option;
    }

    public static <T> Option<T> uninitialized() {
        Option<?> option = UNINITIALIZED;
        return option;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public T getValue() {
        if (!this.isInitialized) {
            throw LOGGER.logExceptionAsError(new NoSuchElementException("No value initialized"));
        }
        return this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Option)) {
            return false;
        }
        Option option = (Option)object;
        if (this.isInitialized ^ option.isInitialized) {
            return false;
        }
        return Objects.equals(this.value, option.value);
    }

    public int hashCode() {
        if (!this.isInitialized) {
            return -1;
        }
        return Objects.hashCode(this.value);
    }

    private Option() {
        this.isInitialized = false;
        this.value = null;
    }

    private Option(T t2) {
        this.isInitialized = true;
        this.value = t2;
    }
}

