/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation;

import java.lang.invoke.MethodHandle;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectiveInvoker;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

final class MethodHandleReflectiveInvoker
implements ReflectiveInvoker {
    private static final ClientLogger LOGGER = new ClientLogger(MethodHandleReflectiveInvoker.class);
    private static final Object[] NO_ARGS = new Object[0];
    private final MethodHandle methodHandle;

    MethodHandleReflectiveInvoker(MethodHandle methodHandle) {
        this.methodHandle = methodHandle;
    }

    @Override
    public Object invokeStatic(Object ... objectArray) throws Exception {
        try {
            return this.methodHandle.invokeWithArguments(objectArray);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error) {
                throw LOGGER.logThrowableAsError((Error)throwable);
            }
            throw LOGGER.logThrowableAsError((Exception)throwable);
        }
    }

    @Override
    public Object invokeWithArguments(Object object, Object ... objectArray) throws Exception {
        try {
            return this.methodHandle.invokeWithArguments(MethodHandleReflectiveInvoker.createFinalArgs(object, objectArray));
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error) {
                throw LOGGER.logThrowableAsError((Error)throwable);
            }
            throw LOGGER.logThrowableAsError((Exception)throwable);
        }
    }

    @Override
    public int getParameterCount() {
        return this.methodHandle.type().parameterCount();
    }

    private static Object[] createFinalArgs(Object object, Object ... objectArray) {
        if (object == null && (objectArray == null || objectArray.length == 0)) {
            return NO_ARGS;
        }
        if (objectArray == null || objectArray.length == 0) {
            return new Object[]{object};
        }
        Object[] objectArray2 = new Object[objectArray.length + 1];
        objectArray2[0] = object;
        System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
        return objectArray2;
    }
}

