/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.RetryOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.RetryStrategy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.accesshelpers.ExponentialBackoffAccessHelper;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.accesshelpers.FixedDelayAccessHelper;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.DateTimeRfc1123;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.FluxUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.UrlBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public final class ImplUtils {
    private static final HttpHeaderName RETRY_AFTER_MS_HEADER = HttpHeaderName.fromString("retry-after-ms");
    private static final HttpHeaderName X_MS_RETRY_AFTER_MS_HEADER = HttpHeaderName.fromString("x-ms-retry-after-ms");
    public static final int MAX_CACHE_SIZE = 10000;
    private static final Charset UTF_32BE = Charset.forName("UTF-32BE");
    private static final Charset UTF_32LE = Charset.forName("UTF-32LE");
    private static final ClientLogger LOGGER = new ClientLogger(ImplUtils.class);
    private static final byte ZERO = 0;
    private static final byte BB = -69;
    private static final byte BF = -65;
    private static final byte EF = -17;
    private static final byte FE = -2;
    private static final byte FF = -1;
    private static final Pattern CHARSET_PATTERN = Pattern.compile("charset=(\\S+)\\b", 2);

    public static Duration getRetryAfterFromHeaders(HttpHeaders httpHeaders, Supplier<OffsetDateTime> supplier) {
        Duration duration = ImplUtils.tryGetRetryDelay(httpHeaders, X_MS_RETRY_AFTER_MS_HEADER, ImplUtils::tryGetDelayMillis);
        if (duration != null) {
            return duration;
        }
        duration = ImplUtils.tryGetRetryDelay(httpHeaders, RETRY_AFTER_MS_HEADER, ImplUtils::tryGetDelayMillis);
        if (duration != null) {
            return duration;
        }
        duration = ImplUtils.tryGetRetryDelay(httpHeaders, HttpHeaderName.RETRY_AFTER, string -> ImplUtils.tryParseLongOrDateTime(string, supplier));
        return duration;
    }

    private static Duration tryGetRetryDelay(HttpHeaders httpHeaders, HttpHeaderName httpHeaderName, Function<String, Duration> function) {
        String string = httpHeaders.getValue(httpHeaderName);
        return CoreUtils.isNullOrEmpty(string) ? null : function.apply(string);
    }

    private static Duration tryGetDelayMillis(String string) {
        long l2 = ImplUtils.tryParseLong(string);
        return l2 >= 0L ? Duration.ofMillis(l2) : null;
    }

    private static Duration tryParseLongOrDateTime(String string, Supplier<OffsetDateTime> supplier) {
        long l2;
        try {
            OffsetDateTime offsetDateTime = new DateTimeRfc1123(string).getDateTime();
            l2 = supplier.get().until(offsetDateTime, ChronoUnit.SECONDS);
        }
        catch (DateTimeException dateTimeException) {
            l2 = ImplUtils.tryParseLong(string);
        }
        return l2 >= 0L ? Duration.ofSeconds(l2) : null;
    }

    private static long tryParseLong(String string) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public static void writeByteBufferToStream(ByteBuffer byteBuffer, OutputStream outputStream) throws IOException {
        if (byteBuffer.hasArray()) {
            outputStream.write(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining());
            byteBuffer.position(byteBuffer.position() + byteBuffer.remaining());
            return;
        }
        if (outputStream instanceof FileOutputStream) {
            FileOutputStream fileOutputStream = (FileOutputStream)outputStream;
            fileOutputStream.getChannel().write(byteBuffer);
            return;
        }
        outputStream.write(FluxUtil.byteBufferToArray(byteBuffer));
    }

    public static UrlBuilder parseUrl(URL uRL, boolean bl2) {
        UrlBuilder urlBuilder = new UrlBuilder();
        if (uRL != null) {
            String string;
            String string2;
            int n2;
            String string3;
            String string4 = uRL.getProtocol();
            if (string4 != null && !string4.isEmpty()) {
                urlBuilder.setScheme(string4);
            }
            if ((string3 = uRL.getHost()) != null && !string3.isEmpty()) {
                urlBuilder.setHost(string3);
            }
            if ((n2 = uRL.getPort()) != -1) {
                urlBuilder.setPort(n2);
            }
            if ((string2 = uRL.getPath()) != null && !string2.isEmpty()) {
                urlBuilder.setPath(string2);
            }
            if ((string = uRL.getQuery()) != null && !string.isEmpty() && bl2) {
                urlBuilder.setQuery(string);
            }
        }
        return urlBuilder;
    }

    public static String bomAwareToString(byte[] byArray, int n2, int n3, String string) {
        if (byArray == null) {
            return null;
        }
        if (n3 >= 3 && byArray[n2] == -17 && byArray[n2 + 1] == -69 && byArray[n2 + 2] == -65) {
            return new String(byArray, 3, byArray.length - 3, StandardCharsets.UTF_8);
        }
        if (n3 >= 4 && byArray[n2] == 0 && byArray[n2 + 1] == 0 && byArray[n2 + 2] == -2 && byArray[n2 + 3] == -1) {
            return new String(byArray, 4, byArray.length - 4, UTF_32BE);
        }
        if (n3 >= 4 && byArray[n2] == -1 && byArray[n2 + 1] == -2 && byArray[n2 + 2] == 0 && byArray[n2 + 3] == 0) {
            return new String(byArray, 4, byArray.length - 4, UTF_32LE);
        }
        if (n3 >= 2 && byArray[n2] == -2 && byArray[n2 + 1] == -1) {
            return new String(byArray, 2, byArray.length - 2, StandardCharsets.UTF_16BE);
        }
        if (n3 >= 2 && byArray[n2] == -1 && byArray[n2 + 1] == -2) {
            return new String(byArray, 2, byArray.length - 2, StandardCharsets.UTF_16LE);
        }
        if (!CoreUtils.isNullOrEmpty(string)) {
            try {
                Matcher matcher = CHARSET_PATTERN.matcher(string);
                if (matcher.find()) {
                    return new String(byArray, n2, n3, Charset.forName(matcher.group(1)));
                }
                return new String(byArray, n2, n3, StandardCharsets.UTF_8);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
                return new String(byArray, n2, n3, StandardCharsets.UTF_8);
            }
        }
        return new String(byArray, n2, n3, StandardCharsets.UTF_8);
    }

    public static URL createUrl(String string) throws MalformedURLException {
        return new URL(string);
    }

    public static <T> Class<? extends T> getClassByName(String string) {
        Objects.requireNonNull(string, "'className' cannot be null");
        try {
            return Class.forName(string, false, ImplUtils.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Class '" + string + "' is not found on the classpath.", classNotFoundException));
        }
    }

    public static RetryStrategy getRetryStrategyFromOptions(RetryOptions retryOptions) {
        Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
        if (retryOptions.getExponentialBackoffOptions() != null) {
            return ExponentialBackoffAccessHelper.create(retryOptions.getExponentialBackoffOptions(), retryOptions.getShouldRetryCondition());
        }
        if (retryOptions.getFixedDelayOptions() != null) {
            return FixedDelayAccessHelper.create(retryOptions.getFixedDelayOptions(), retryOptions.getShouldRetryCondition());
        }
        throw new IllegalArgumentException("'retryOptions' didn't define any retry strategy options");
    }

    public static void fullyWriteBuffer(ByteBuffer byteBuffer, WritableByteChannel writableByteChannel) throws IOException {
        while (byteBuffer.hasRemaining()) {
            writableByteChannel.write(byteBuffer);
        }
    }

    public static <E extends Throwable> void sneakyThrows(Throwable throwable) throws E {
        throw throwable;
    }

    public static <T> T getResultWithTimeout(Future<T> future, long l2) throws InterruptedException, ExecutionException, TimeoutException {
        Objects.requireNonNull(future, "'future' cannot be null.");
        if (l2 <= 0L) {
            return future.get();
        }
        try {
            return future.get(l2, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            future.cancel(true);
            throw timeoutException;
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            ImplUtils.sneakyThrows(throwable);
            throw executionException;
        }
    }

    public static Thread addShutdownHookSafely(Thread thread) {
        if (thread == null) {
            return null;
        }
        if (ShutdownHookAccessHelperHolder.shutdownHookAccessHelper) {
            AccessController.doPrivileged(() -> {
                Runtime.getRuntime().addShutdownHook(thread);
                return null;
            });
        } else {
            Runtime.getRuntime().addShutdownHook(thread);
        }
        return thread;
    }

    public static void removeShutdownHookSafely(Thread thread) {
        if (thread == null) {
            return;
        }
        if (ShutdownHookAccessHelperHolder.shutdownHookAccessHelper) {
            AccessController.doPrivileged(() -> {
                Runtime.getRuntime().removeShutdownHook(thread);
                return null;
            });
        } else {
            Runtime.getRuntime().removeShutdownHook(thread);
        }
    }

    static boolean isShutdownHookAccessHelper() {
        return ShutdownHookAccessHelperHolder.shutdownHookAccessHelper;
    }

    static void setShutdownHookAccessHelper(boolean bl2) {
        ShutdownHookAccessHelperHolder.shutdownHookAccessHelper = bl2;
    }

    private ImplUtils() {
    }

    private static final class ShutdownHookAccessHelperHolder {
        private static boolean shutdownHookAccessHelper = Boolean.parseBoolean(Configuration.getGlobalConfiguration().get("AZURE_ENABLE_SHUTDOWN_HOOK_WITH_PRIVILEGE"));

        private ShutdownHookAccessHelperHolder() {
        }
    }

    public static final class QueryParameterIterator
    implements Iterator<Map.Entry<String, String>> {
        private final String queryParameters;
        private final int queryParametersLength;
        private boolean done = false;
        private int position;

        public QueryParameterIterator(String string) {
            this.queryParameters = string;
            this.queryParametersLength = string.length();
            this.position = string.startsWith("?") ? 1 : 0;
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public Map.Entry<String, String> next() {
            char c2;
            int n2;
            if (this.done) {
                throw new NoSuchElementException();
            }
            for (n2 = this.position; n2 < this.queryParametersLength && (c2 = this.queryParameters.charAt(n2)) != '='; ++n2) {
                if (c2 != '&') continue;
                String string = this.queryParameters.substring(this.position, n2);
                this.position = n2 + 1;
                return new AbstractMap.SimpleImmutableEntry<String, String>(string, "");
            }
            if (n2 == this.queryParametersLength) {
                this.done = true;
                return new AbstractMap.SimpleImmutableEntry<String, String>(this.queryParameters.substring(this.position), "");
            }
            String string = this.queryParameters.substring(this.position, n2);
            this.position = n2 + 1;
            n2 = this.queryParameters.indexOf(38, this.position);
            String string2 = null;
            if (n2 == -1) {
                this.done = true;
                string2 = this.queryParameters.substring(this.position);
            } else {
                string2 = this.queryParameters.substring(this.position, n2);
                this.position = n2 + 1;
            }
            return new AbstractMap.SimpleImmutableEntry<String, String>(string, string2);
        }
    }
}

