/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.CompletionHandler;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ProgressReporter;

public class ByteCountingAsynchronousByteChannel
implements AsynchronousByteChannel {
    private final AsynchronousByteChannel channel;
    private final ProgressReporter readProgressReporter;
    private final ProgressReporter writeProgressReporter;
    private static final AtomicLongFieldUpdater<ByteCountingAsynchronousByteChannel> BYTES_WRITTEN_ATOMIC_UPDATER = AtomicLongFieldUpdater.newUpdater(ByteCountingAsynchronousByteChannel.class, "bytesWritten");
    private volatile long bytesWritten;
    private static final AtomicLongFieldUpdater<ByteCountingAsynchronousByteChannel> BYTES_READ_ATOMIC_UPDATER = AtomicLongFieldUpdater.newUpdater(ByteCountingAsynchronousByteChannel.class, "bytesRead");
    private volatile long bytesRead;

    public ByteCountingAsynchronousByteChannel(AsynchronousByteChannel asynchronousByteChannel, ProgressReporter progressReporter, ProgressReporter progressReporter2) {
        this.channel = Objects.requireNonNull(asynchronousByteChannel, "'channel' must not be null");
        this.readProgressReporter = progressReporter;
        this.writeProgressReporter = progressReporter2;
    }

    @Override
    public <A> void read(ByteBuffer byteBuffer, A a2, CompletionHandler<Integer, ? super A> completionHandler) {
        this.channel.read(byteBuffer, a2, new DelegatingCompletionHandler(completionHandler, BYTES_READ_ATOMIC_UPDATER, this.readProgressReporter));
    }

    @Override
    public Future<Integer> read(ByteBuffer byteBuffer) {
        CompletableFuture<Integer> completableFuture = new CompletableFuture<Integer>();
        this.channel.read(byteBuffer, byteBuffer, new DelegatingCompletionHandler(completableFuture, BYTES_READ_ATOMIC_UPDATER, this.readProgressReporter));
        return completableFuture;
    }

    @Override
    public <A> void write(ByteBuffer byteBuffer, A a2, CompletionHandler<Integer, ? super A> completionHandler) {
        this.channel.write(byteBuffer, a2, new DelegatingCompletionHandler(completionHandler, BYTES_WRITTEN_ATOMIC_UPDATER, this.writeProgressReporter));
    }

    @Override
    public Future<Integer> write(ByteBuffer byteBuffer) {
        CompletableFuture<Integer> completableFuture = new CompletableFuture<Integer>();
        this.channel.write(byteBuffer, byteBuffer, new DelegatingCompletionHandler(completableFuture, BYTES_WRITTEN_ATOMIC_UPDATER, this.writeProgressReporter));
        return completableFuture;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public long getBytesWritten() {
        return BYTES_WRITTEN_ATOMIC_UPDATER.get(this);
    }

    public long getBytesRead() {
        return BYTES_READ_ATOMIC_UPDATER.get(this);
    }

    private final class DelegatingCompletionHandler<T>
    implements CompletionHandler<Integer, T> {
        private final CompletionHandler<Integer, ? super T> handler;
        private final CompletableFuture<Integer> future;
        private final AtomicLongFieldUpdater<ByteCountingAsynchronousByteChannel> atomicLongFieldUpdater;
        private final ProgressReporter progressReporter;

        private DelegatingCompletionHandler(CompletionHandler<Integer, ? super T> completionHandler, AtomicLongFieldUpdater<ByteCountingAsynchronousByteChannel> atomicLongFieldUpdater, ProgressReporter progressReporter) {
            this.handler = completionHandler;
            this.future = null;
            this.atomicLongFieldUpdater = atomicLongFieldUpdater;
            this.progressReporter = progressReporter;
        }

        private DelegatingCompletionHandler(CompletableFuture<Integer> completableFuture, AtomicLongFieldUpdater<ByteCountingAsynchronousByteChannel> atomicLongFieldUpdater, ProgressReporter progressReporter) {
            this.handler = null;
            this.future = completableFuture;
            this.atomicLongFieldUpdater = atomicLongFieldUpdater;
            this.progressReporter = progressReporter;
        }

        @Override
        public void completed(Integer n2, T t2) {
            if (n2 > 0) {
                this.atomicLongFieldUpdater.addAndGet(ByteCountingAsynchronousByteChannel.this, n2.intValue());
                if (this.progressReporter != null) {
                    this.progressReporter.reportProgress(n2.intValue());
                }
            }
            if (this.handler != null) {
                this.handler.completed(n2, t2);
            } else if (this.future != null) {
                this.future.complete(n2);
            }
        }

        @Override
        public void failed(Throwable throwable, T t2) {
            if (this.handler != null) {
                this.handler.failed(throwable, t2);
            } else if (this.future != null) {
                this.future.completeExceptionally(throwable);
            }
        }
    }
}

