/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.SimpleResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.FluxUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.org.reactivestreams.Publisher;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public final class StreamResponse
extends SimpleResponse<Flux<ByteBuffer>>
implements Closeable {
    private static final ClientLogger LOGGER = new ClientLogger(StreamResponse.class);
    private volatile boolean consumed;
    private final HttpResponse response;

    @Deprecated
    public StreamResponse(HttpRequest httpRequest, int n2, HttpHeaders httpHeaders, Flux<ByteBuffer> flux) {
        super(httpRequest, n2, httpHeaders, flux);
        this.response = null;
    }

    public StreamResponse(HttpResponse httpResponse) {
        super(httpResponse.getRequest(), httpResponse.getStatusCode(), httpResponse.getHeaders(), null);
        this.response = httpResponse;
    }

    @Override
    public Flux<ByteBuffer> getValue() {
        if (this.response == null) {
            return Flux.using(() -> this, streamResponse -> (Publisher)super.getValue(), streamResponse -> {
                streamResponse.consumed = true;
            });
        }
        return Flux.using(() -> this.response, HttpResponse::getBody, httpResponse -> {
            this.consumed = true;
            httpResponse.close();
        });
    }

    public Mono<Void> writeValueToAsync(AsynchronousByteChannel asynchronousByteChannel) {
        Objects.requireNonNull(asynchronousByteChannel, "'channel' must not be null");
        if (this.response == null) {
            return FluxUtil.writeToAsynchronousByteChannel(this.getValue(), asynchronousByteChannel);
        }
        return this.response.writeBodyToAsync(asynchronousByteChannel);
    }

    public void writeValueTo(WritableByteChannel writableByteChannel) {
        Objects.requireNonNull(writableByteChannel, "'channel' must not be null");
        if (this.response == null) {
            FluxUtil.writeToWritableByteChannel(this.getValue(), writableByteChannel).block();
        } else {
            try {
                this.response.writeBodyTo(writableByteChannel);
            }
            catch (IOException iOException) {
                throw LOGGER.logExceptionAsError(new UncheckedIOException(iOException));
            }
        }
    }

    @Override
    public void close() {
        if (this.consumed) {
            return;
        }
        this.consumed = true;
        if (this.response == null) {
            Flux<ByteBuffer> flux = this.getValue();
            flux.subscribe().dispose();
        } else {
            this.response.close();
        }
    }
}

