/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest;

import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Consumer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.ErrorOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.UrlEscapers;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.BinaryData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Context;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public final class RequestOptions {
    private static final ClientLogger LOGGER = new ClientLogger(RequestOptions.class);
    private static final EnumSet<ErrorOptions> DEFAULT = EnumSet.of(ErrorOptions.THROW);
    private Consumer<HttpRequest> requestCallback = httpRequest -> {};
    private EnumSet<ErrorOptions> errorOptions = DEFAULT;
    private Context context;

    Consumer<HttpRequest> getRequestCallback() {
        return this.requestCallback;
    }

    EnumSet<ErrorOptions> getErrorOptions() {
        return this.errorOptions;
    }

    public Context getContext() {
        return this.context;
    }

    @Deprecated
    public RequestOptions addHeader(String string, String string2) {
        this.requestCallback = this.requestCallback.andThen(httpRequest -> httpRequest.getHeaders().add(string, string2));
        return this;
    }

    public RequestOptions addHeader(HttpHeaderName httpHeaderName, String string) {
        this.requestCallback = this.requestCallback.andThen(httpRequest -> httpRequest.getHeaders().add(httpHeaderName, string));
        return this;
    }

    @Deprecated
    public RequestOptions setHeader(String string, String string2) {
        this.requestCallback = this.requestCallback.andThen(httpRequest -> httpRequest.getHeaders().set(string, string2));
        return this;
    }

    public RequestOptions setHeader(HttpHeaderName httpHeaderName, String string) {
        this.requestCallback = this.requestCallback.andThen(httpRequest -> httpRequest.getHeaders().set(httpHeaderName, string));
        return this;
    }

    public RequestOptions addQueryParam(String string, String string2) {
        return this.addQueryParam(string, string2, false);
    }

    public RequestOptions addQueryParam(String string, String string2, boolean bl2) {
        this.requestCallback = this.requestCallback.andThen(httpRequest -> {
            String string3 = httpRequest.getUrl().toString();
            String string4 = bl2 ? string : UrlEscapers.QUERY_ESCAPER.escape(string);
            String string5 = bl2 ? string2 : UrlEscapers.QUERY_ESCAPER.escape(string2);
            httpRequest.setUrl(string3 + (string3.contains("?") ? "&" : "?") + string4 + "=" + string5);
        });
        return this;
    }

    public RequestOptions addRequestCallback(Consumer<HttpRequest> consumer) {
        Objects.requireNonNull(consumer, "'requestCallback' cannot be null.");
        this.requestCallback = this.requestCallback.andThen(consumer);
        return this;
    }

    public RequestOptions setBody(BinaryData binaryData) {
        Objects.requireNonNull(binaryData, "'requestBody' cannot be null.");
        this.requestCallback = this.requestCallback.andThen(httpRequest -> httpRequest.setBody(binaryData));
        return this;
    }

    RequestOptions setErrorOptions(EnumSet<ErrorOptions> enumSet) {
        Objects.requireNonNull(enumSet, "'errorOptions' cannot be null.");
        if (enumSet.contains((Object)ErrorOptions.THROW) && enumSet.contains((Object)ErrorOptions.NO_THROW)) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'errorOptions' cannot contain both 'ErrorOptions.THROW' and 'ErrorOptions.NO_THROW'."));
        }
        this.errorOptions = enumSet;
        return this;
    }

    public RequestOptions setContext(Context context) {
        this.context = context;
        return this;
    }
}

