/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy;

import java.net.MalformedURLException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineCallContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextSyncPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelinePolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelineSyncPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.UrlBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class ProtocolPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(ProtocolPolicy.class);
    private final String protocol;
    private final boolean overwrite;
    private final HttpPipelineSyncPolicy inner = new HttpPipelineSyncPolicy(){

        @Override
        protected void beforeSendingRequest(HttpPipelineCallContext httpPipelineCallContext) {
            UrlBuilder urlBuilder = UrlBuilder.parse(httpPipelineCallContext.getHttpRequest().getUrl());
            if (ProtocolPolicy.this.overwrite || urlBuilder.getScheme() == null) {
                LOGGER.atVerbose().addKeyValue("protocol", ProtocolPolicy.this.protocol).log("Setting protocol");
                try {
                    httpPipelineCallContext.getHttpRequest().setUrl(urlBuilder.setScheme(ProtocolPolicy.this.protocol).toUrl());
                }
                catch (MalformedURLException malformedURLException) {
                    throw LOGGER.logExceptionAsError(new RuntimeException("Failed to set the HTTP request protocol to " + ProtocolPolicy.this.protocol + ".", malformedURLException));
                }
            }
        }
    };

    public ProtocolPolicy(String string, boolean bl2) {
        this.protocol = string;
        this.overwrite = bl2;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextPolicy httpPipelineNextPolicy) {
        return this.inner.process(httpPipelineCallContext, httpPipelineNextPolicy);
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextSyncPolicy httpPipelineNextSyncPolicy) {
        return this.inner.processSync(httpPipelineCallContext, httpPipelineNextSyncPolicy);
    }
}

