/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpLogDetailLevel;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpRequestLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpResponseLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public class HttpLogOptions {
    private String applicationId = null;
    private HttpLogDetailLevel logLevel = HttpLogDetailLevel.ENVIRONMENT_HTTP_LOG_DETAIL_LEVEL;
    private Set<String> allowedHeaderNames = new HashSet<String>(DEFAULT_HEADERS_ALLOWLIST);
    private Set<String> allowedQueryParamNames = new HashSet<String>(DEFAULT_QUERY_PARAMS_ALLOWLIST);
    private boolean prettyPrintBody;
    private boolean disableRedactedHeaderLogging;
    private HttpRequestLogger requestLogger;
    private HttpResponseLogger responseLogger;
    private static final ClientLogger LOGGER = new ClientLogger(HttpLogOptions.class);
    private static final int MAX_APPLICATION_ID_LENGTH = 24;
    private static final String INVALID_APPLICATION_ID_LENGTH = "'applicationId' length cannot be greater than 24";
    private static final String INVALID_APPLICATION_ID_SPACE = "'applicationId' cannot contain spaces.";
    static final List<String> DEFAULT_HEADERS_ALLOWLIST = Arrays.asList("x-ms-request-id", "x-ms-client-request-id", "x-ms-return-client-request-id", "traceparent", "MS-CV", "Accept", "Cache-Control", "Connection", "Content-Length", "Content-Type", "Date", "ETag", "Expires", "If-Match", "If-Modified-Since", "If-None-Match", "If-Unmodified-Since", "Last-Modified", "Pragma", "Request-Id", "Retry-After", "Server", "Transfer-Encoding", "User-Agent", "WWW-Authenticate");
    static final List<String> DEFAULT_QUERY_PARAMS_ALLOWLIST = Collections.singletonList("api-version");

    public HttpLogDetailLevel getLogLevel() {
        return this.logLevel;
    }

    public HttpLogOptions setLogLevel(HttpLogDetailLevel httpLogDetailLevel) {
        this.logLevel = httpLogDetailLevel == null ? HttpLogDetailLevel.NONE : httpLogDetailLevel;
        return this;
    }

    public Set<String> getAllowedHeaderNames() {
        return this.allowedHeaderNames;
    }

    public HttpLogOptions setAllowedHeaderNames(Set<String> hashSet) {
        this.allowedHeaderNames = hashSet == null ? new HashSet() : hashSet;
        return this;
    }

    public HttpLogOptions addAllowedHeaderName(String string) {
        Objects.requireNonNull(string);
        this.allowedHeaderNames.add(string);
        return this;
    }

    public Set<String> getAllowedQueryParamNames() {
        return this.allowedQueryParamNames;
    }

    public HttpLogOptions setAllowedQueryParamNames(Set<String> hashSet) {
        this.allowedQueryParamNames = hashSet == null ? new HashSet() : hashSet;
        return this;
    }

    public HttpLogOptions addAllowedQueryParamName(String string) {
        this.allowedQueryParamNames.add(string);
        this.getClass().getName();
        return this;
    }

    @Deprecated
    public String getApplicationId() {
        return this.applicationId;
    }

    @Deprecated
    public HttpLogOptions setApplicationId(String string) {
        if (!CoreUtils.isNullOrEmpty(string)) {
            if (string.length() > 24) {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException(INVALID_APPLICATION_ID_LENGTH));
            }
            if (string.contains(" ")) {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException(INVALID_APPLICATION_ID_SPACE));
            }
        }
        this.applicationId = string;
        return this;
    }

    public boolean isPrettyPrintBody() {
        return this.prettyPrintBody;
    }

    public HttpLogOptions setPrettyPrintBody(boolean bl2) {
        this.prettyPrintBody = bl2;
        return this;
    }

    public HttpRequestLogger getRequestLogger() {
        return this.requestLogger;
    }

    public HttpLogOptions setRequestLogger(HttpRequestLogger httpRequestLogger) {
        this.requestLogger = httpRequestLogger;
        return this;
    }

    public HttpResponseLogger getResponseLogger() {
        return this.responseLogger;
    }

    public HttpLogOptions setResponseLogger(HttpResponseLogger httpResponseLogger) {
        this.responseLogger = httpResponseLogger;
        return this;
    }

    public HttpLogOptions disableRedactedHeaderLogging(boolean bl2) {
        this.disableRedactedHeaderLogging = bl2;
        return this;
    }

    public boolean isRedactedHeaderLoggingDisabled() {
        return this.disableRedactedHeaderLogging;
    }
}

