/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy;

import java.time.Duration;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public class FixedDelayOptions {
    private static final ClientLogger LOGGER = new ClientLogger(FixedDelayOptions.class);
    private final int maxRetries;
    private final Duration delay;

    public FixedDelayOptions(int n2, Duration duration) {
        if (n2 < 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("Max retries cannot be less than 0."));
        }
        this.maxRetries = n2;
        this.delay = Objects.requireNonNull(duration, "'delay' cannot be null.");
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public Duration getDelay() {
        return this.delay;
    }
}

