/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy;

import java.time.Duration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public class ExponentialBackoffOptions {
    private static final ClientLogger LOGGER = new ClientLogger(ExponentialBackoffOptions.class);
    private Integer maxRetries;
    private Duration baseDelay;
    private Duration maxDelay;

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public ExponentialBackoffOptions setMaxRetries(Integer n2) {
        if (n2 != null && n2 < 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("Max retries cannot be less than 0."));
        }
        this.maxRetries = n2;
        return this;
    }

    public Duration getBaseDelay() {
        return this.baseDelay;
    }

    public ExponentialBackoffOptions setBaseDelay(Duration duration) {
        this.validateDelays(duration, this.maxDelay);
        this.baseDelay = duration;
        return this;
    }

    public Duration getMaxDelay() {
        return this.maxDelay;
    }

    public ExponentialBackoffOptions setMaxDelay(Duration duration) {
        this.validateDelays(this.baseDelay, duration);
        this.maxDelay = duration;
        return this;
    }

    private void validateDelays(Duration duration, Duration duration2) {
        if (duration != null && (duration.isZero() || duration.isNegative())) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'baseDelay' cannot be negative or 0."));
        }
        if (duration2 != null && (duration2.isZero() || duration2.isNegative())) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'maxDelay' cannot be negative or 0."));
        }
        if (duration != null && duration2 != null && duration.compareTo(duration2) > 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'baseDelay' cannot be greater than 'maxDelay'."));
        }
    }
}

