/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy;

import java.util.EnumSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineCallContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.RedirectStrategy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;

public final class DefaultRedirectStrategy
implements RedirectStrategy {
    private static final ClientLogger LOGGER = new ClientLogger(DefaultRedirectStrategy.class);
    private static final int DEFAULT_MAX_REDIRECT_ATTEMPTS = 3;
    private static final int PERMANENT_REDIRECT_STATUS_CODE = 308;
    private static final int TEMPORARY_REDIRECT_STATUS_CODE = 307;
    private static final Set<HttpMethod> DEFAULT_REDIRECT_ALLOWED_METHODS = EnumSet.of(HttpMethod.GET, HttpMethod.HEAD);
    private static final String REDIRECT_URLS_KEY = "redirectUrls";
    private final int maxAttempts;
    private final HttpHeaderName locationHeader;
    private final Set<HttpMethod> allowedRedirectHttpMethods;

    public DefaultRedirectStrategy() {
        this(3, HttpHeaderName.LOCATION, DEFAULT_REDIRECT_ALLOWED_METHODS);
    }

    public DefaultRedirectStrategy(int n2) {
        this(n2, HttpHeaderName.LOCATION, DEFAULT_REDIRECT_ALLOWED_METHODS);
    }

    public DefaultRedirectStrategy(int n2, String string, Set<HttpMethod> set) {
        this(n2, DefaultRedirectStrategy.validateLocationHeader(string), DefaultRedirectStrategy.validateAllowedMethods(set));
    }

    private DefaultRedirectStrategy(int n2, HttpHeaderName httpHeaderName, Set<HttpMethod> set) {
        if (n2 < 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("Max attempts cannot be less than 0."));
        }
        this.maxAttempts = n2;
        this.locationHeader = httpHeaderName;
        this.allowedRedirectHttpMethods = set;
    }

    private static HttpHeaderName validateLocationHeader(String string) {
        if (CoreUtils.isNullOrEmpty(string)) {
            LOGGER.log(LogLevel.INFORMATIONAL, () -> "'locationHeader' provided as null will be defaulted to " + HttpHeaderName.LOCATION);
            return HttpHeaderName.LOCATION;
        }
        return HttpHeaderName.fromString(string);
    }

    private static Set<HttpMethod> validateAllowedMethods(Set<HttpMethod> set) {
        if (CoreUtils.isNullOrEmpty(set)) {
            LOGGER.log(LogLevel.INFORMATIONAL, () -> "'allowedMethods' provided as null will be defaulted to " + DEFAULT_REDIRECT_ALLOWED_METHODS);
            return DEFAULT_REDIRECT_ALLOWED_METHODS;
        }
        return EnumSet.copyOf(set);
    }

    @Override
    public boolean shouldAttemptRedirect(HttpPipelineCallContext httpPipelineCallContext, HttpResponse httpResponse, int n2, Set<String> set) {
        if (this.isValidRedirectStatusCode(httpResponse.getStatusCode()) && this.isValidRedirectCount(n2) && this.isAllowedRedirectMethod(httpResponse.getRequest().getHttpMethod())) {
            String string = httpResponse.getHeaderValue(this.locationHeader);
            if (string != null && !this.alreadyAttemptedRedirectUrl(string, set)) {
                LOGGER.atVerbose().addKeyValue("tryCount", n2).addKeyValue(REDIRECT_URLS_KEY, set::toString).log("Redirecting.");
                set.add(string);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public HttpRequest createRedirectRequest(HttpResponse httpResponse) {
        return httpResponse.getRequest().setUrl(httpResponse.getHeaderValue(this.locationHeader));
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    private boolean alreadyAttemptedRedirectUrl(String string, Set<String> set) {
        if (set.contains(string)) {
            LOGGER.atError().addKeyValue("redirectUrl", string).log("Request was redirected more than once to the same URL.");
            return true;
        }
        return false;
    }

    private boolean isValidRedirectCount(int n2) {
        if (n2 >= this.getMaxAttempts()) {
            LOGGER.atError().addKeyValue("maxAttempts", this.getMaxAttempts()).log("Redirect attempts have been exhausted.");
            return false;
        }
        return true;
    }

    private boolean isAllowedRedirectMethod(HttpMethod httpMethod) {
        if (this.allowedRedirectHttpMethods.contains((Object)httpMethod)) {
            return true;
        }
        LOGGER.atError().addKeyValue("method", (Object)httpMethod).log("Request was redirected from an invalid redirect allowed method.");
        return false;
    }

    private boolean isValidRedirectStatusCode(int n2) {
        return n2 == 302 || n2 == 301 || n2 == 308 || n2 == 307;
    }
}

