/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AzureSasCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineCallContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextSyncPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelinePolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelineSyncPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public final class AzureSasCredentialPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(AzureSasCredentialPolicy.class);
    private final AzureSasCredential credential;
    private final boolean requireHttps;
    private final HttpPipelineSyncPolicy inner = new HttpPipelineSyncPolicy(){

        @Override
        protected void beforeSendingRequest(HttpPipelineCallContext httpPipelineCallContext) {
            HttpRequest httpRequest = httpPipelineCallContext.getHttpRequest();
            if (AzureSasCredentialPolicy.this.requireHttps && !"https".equals(httpRequest.getUrl().getProtocol())) {
                throw LOGGER.logExceptionAsError(new IllegalStateException("Shared access signature credentials require HTTPS to prevent leaking the shared access signature."));
            }
            String string = AzureSasCredentialPolicy.this.credential.getSignature();
            if (string.startsWith("?")) {
                string = string.substring(1);
            }
            String string2 = httpRequest.getUrl().getQuery();
            String string3 = httpRequest.getUrl().toString();
            string3 = string2 == null || string2.isEmpty() ? (string3.endsWith("?") ? string3 + string : string3 + "?" + string) : string3 + "&" + string;
            httpRequest.setUrl(string3);
        }
    };

    public AzureSasCredentialPolicy(AzureSasCredential azureSasCredential) {
        this(azureSasCredential, true);
    }

    public AzureSasCredentialPolicy(AzureSasCredential azureSasCredential, boolean bl2) {
        Objects.requireNonNull(azureSasCredential, "'credential' cannot be null.");
        this.credential = azureSasCredential;
        this.requireHttps = bl2;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextPolicy httpPipelineNextPolicy) {
        return this.inner.process(httpPipelineCallContext, httpPipelineNextPolicy);
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextSyncPolicy httpPipelineNextSyncPolicy) {
        return this.inner.processSync(httpPipelineCallContext, httpPipelineNextSyncPolicy);
    }
}

