/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineCallContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextSyncPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelinePolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.DateTimeRfc1123;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class AddDatePolicy
implements HttpPipelinePolicy {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'").withZone(ZoneOffset.UTC).withLocale(Locale.US);

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextPolicy httpPipelineNextPolicy) {
        return Mono.defer(() -> {
            AddDatePolicy.setDate(httpPipelineCallContext);
            return httpPipelineNextPolicy.process();
        });
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextSyncPolicy httpPipelineNextSyncPolicy) {
        AddDatePolicy.setDate(httpPipelineCallContext);
        return httpPipelineNextSyncPolicy.processSync();
    }

    private static void setDate(HttpPipelineCallContext httpPipelineCallContext) {
        OffsetDateTime offsetDateTime = OffsetDateTime.now(ZoneOffset.UTC);
        try {
            httpPipelineCallContext.getHttpRequest().setHeader(HttpHeaderName.DATE, DateTimeRfc1123.toRfc1123String(offsetDateTime));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            httpPipelineCallContext.getHttpRequest().setHeader(HttpHeaderName.DATE, FORMATTER.format(offsetDateTime));
        }
    }
}

