/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.okhttp.implementation;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import macromedia.jdbc.sqlserver.externals.okhttp3.Call;

public final class PerCallTimeoutCall {
    private static final Timer TIMER = new Timer("azure-okhttp-response-timeout-tracker", true);
    private final long perCallTimeout;
    private volatile boolean timedOut;
    private static final AtomicReferenceFieldUpdater<PerCallTimeoutCall, TimerTask> CURRENT_TIMEOUT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(PerCallTimeoutCall.class, TimerTask.class, "currentTimeout");
    private volatile TimerTask currentTimeout;

    public PerCallTimeoutCall(long l2) {
        this.perCallTimeout = l2;
    }

    public void beginPerCallTimeout(Call call) {
        if (this.perCallTimeout > 0L) {
            PerCallTimerTask perCallTimerTask = new PerCallTimerTask(this, call);
            TIMER.schedule((TimerTask)perCallTimerTask, this.perCallTimeout);
            TimerTask timerTask = CURRENT_TIMEOUT_UPDATER.getAndSet(this, perCallTimerTask);
            if (timerTask != null) {
                timerTask.cancel();
            }
        }
    }

    public void endPerCallTimeout() {
        TimerTask timerTask = CURRENT_TIMEOUT_UPDATER.getAndSet(this, null);
        if (timerTask != null) {
            timerTask.cancel();
        }
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    private static final class PerCallTimerTask
    extends TimerTask {
        private final PerCallTimeoutCall perCallTimeoutCall;
        private final Call call;

        PerCallTimerTask(PerCallTimeoutCall perCallTimeoutCall, Call call) {
            this.perCallTimeoutCall = perCallTimeoutCall;
            this.call = call;
        }

        @Override
        public void run() {
            this.perCallTimeoutCall.timedOut = true;
            this.call.cancel();
        }
    }
}

