/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.okhttp.implementation;

import java.io.IOException;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ProgressReporter;
import macromedia.jdbc.sqlserver.externals.okhttp3.MediaType;
import macromedia.jdbc.sqlserver.externals.okhttp3.RequestBody;
import macromedia.jdbc.sqlserver.externals.okio.Buffer;
import macromedia.jdbc.sqlserver.externals.okio.BufferedSink;
import macromedia.jdbc.sqlserver.externals.okio.ForwardingSink;
import macromedia.jdbc.sqlserver.externals.okio.Okio;
import macromedia.jdbc.sqlserver.externals.okio.Sink;

public final class OkHttpProgressReportingRequestBody
extends RequestBody {
    private final RequestBody delegate;
    private final ProgressReporter progressReporter;

    public OkHttpProgressReportingRequestBody(RequestBody requestBody, ProgressReporter progressReporter) {
        this.delegate = Objects.requireNonNull(requestBody, "'delegate' must not be null");
        this.progressReporter = Objects.requireNonNull(progressReporter, "'progressReporter' must not be null");
    }

    public MediaType contentType() {
        return this.delegate.contentType();
    }

    public long contentLength() throws IOException {
        return this.delegate.contentLength();
    }

    public boolean isOneShot() {
        return this.delegate.isOneShot();
    }

    public boolean isDuplex() {
        return this.delegate.isDuplex();
    }

    public void writeTo(BufferedSink bufferedSink) throws IOException {
        CountingSink countingSink = new CountingSink((Sink)bufferedSink, this.progressReporter);
        BufferedSink bufferedSink2 = Okio.buffer((Sink)countingSink);
        this.delegate.writeTo(bufferedSink2);
        bufferedSink2.flush();
    }

    private static final class CountingSink
    extends ForwardingSink {
        private final ProgressReporter progressReporter;

        CountingSink(Sink sink, ProgressReporter progressReporter) {
            super(sink);
            this.progressReporter = progressReporter;
        }

        public void write(Buffer buffer, long l2) throws IOException {
            super.write(buffer, l2);
            this.progressReporter.reportProgress(l2);
        }
    }
}

