/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.okhttp.implementation;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.okhttp.implementation.OkHttpAsyncResponseBase;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.BinaryData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.FluxUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.io.IOUtils;
import macromedia.jdbc.sqlserver.externals.okhttp3.Response;
import macromedia.jdbc.sqlserver.externals.okhttp3.ResponseBody;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public final class OkHttpAsyncResponse
extends OkHttpAsyncResponseBase {
    private static final int BYTE_BUFFER_CHUNK_SIZE = 8192;
    private final ResponseBody responseBody;

    public OkHttpAsyncResponse(Response response, HttpRequest httpRequest, boolean bl2) {
        super(response, httpRequest, bl2);
        this.responseBody = response.body();
    }

    @Override
    public BinaryData getBodyAsBinaryData() {
        return BinaryData.fromStream(this.responseBody.byteStream());
    }

    @Override
    public Flux<ByteBuffer> getBody() {
        if (this.responseBody == null) {
            return Flux.empty();
        }
        return Flux.using(() -> ((ResponseBody)this.responseBody).byteStream(), inputStream -> FluxUtil.toFluxByteBuffer(inputStream, 8192), inputStream -> this.close(), (boolean)false);
    }

    @Override
    public Mono<byte[]> getBodyAsByteArray() {
        return Mono.fromCallable(() -> {
            if (this.responseBody == null) {
                return null;
            }
            byte[] byArray = this.responseBody.bytes();
            if (byArray.length == 0) {
                return null;
            }
            return byArray;
        });
    }

    @Override
    public Mono<InputStream> getBodyAsInputStream() {
        if (this.responseBody == null) {
            return Mono.empty();
        }
        return Mono.using(() -> ((ResponseBody)this.responseBody).byteStream(), Mono::just, inputStream -> this.close(), (boolean)false);
    }

    @Override
    public void writeBodyTo(WritableByteChannel writableByteChannel) throws IOException {
        if (this.responseBody != null) {
            try {
                IOUtils.transfer((ReadableByteChannel)this.responseBody.source(), writableByteChannel, this.responseBody.contentLength());
            }
            finally {
                this.close();
            }
        }
    }

    @Override
    public Mono<Void> writeBodyToAsync(AsynchronousByteChannel asynchronousByteChannel) {
        if (this.responseBody != null) {
            return Mono.using(() -> this, okHttpAsyncResponse -> IOUtils.transferAsync((ReadableByteChannel)this.responseBody.source(), asynchronousByteChannel, this.responseBody.contentLength()), OkHttpAsyncResponse::close);
        }
        return Mono.empty();
    }

    @Override
    public void close() {
        if (this.responseBody != null) {
            this.responseBody.close();
        }
    }
}

