/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.okhttp;

import java.net.ProxySelector;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpClient;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.ProxyOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.okhttp.OkHttpAsyncHttpClient;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.okhttp.implementation.OkHttpProxySelector;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.okhttp.implementation.ProxyAuthenticator;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.HttpUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.okhttp3.Authenticator;
import macromedia.jdbc.sqlserver.externals.okhttp3.ConnectionPool;
import macromedia.jdbc.sqlserver.externals.okhttp3.Dispatcher;
import macromedia.jdbc.sqlserver.externals.okhttp3.Interceptor;
import macromedia.jdbc.sqlserver.externals.okhttp3.OkHttpClient;

public class OkHttpAsyncHttpClientBuilder {
    private static final ClientLogger LOGGER = new ClientLogger(OkHttpAsyncHttpClientBuilder.class);
    private final OkHttpClient okHttpClient;
    private List<Interceptor> networkInterceptors = new ArrayList<Interceptor>();
    private Duration readTimeout;
    private Duration responseTimeout;
    private Duration writeTimeout;
    private Duration connectionTimeout;
    private Duration callTimeout;
    private ConnectionPool connectionPool;
    private Dispatcher dispatcher;
    private ProxyOptions proxyOptions;
    private Configuration configuration;
    private boolean followRedirects;

    public OkHttpAsyncHttpClientBuilder() {
        this.okHttpClient = null;
    }

    public OkHttpAsyncHttpClientBuilder(OkHttpClient okHttpClient) {
        this.okHttpClient = Objects.requireNonNull(okHttpClient, "'okHttpClient' cannot be null.");
    }

    public OkHttpAsyncHttpClientBuilder addNetworkInterceptor(Interceptor interceptor) {
        Objects.requireNonNull(interceptor, "'networkInterceptor' cannot be null.");
        this.networkInterceptors.add(interceptor);
        return this;
    }

    public OkHttpAsyncHttpClientBuilder networkInterceptors(List<Interceptor> list) {
        this.networkInterceptors = Objects.requireNonNull(list, "'networkInterceptors' cannot be null.");
        return this;
    }

    public OkHttpAsyncHttpClientBuilder readTimeout(Duration duration) {
        this.readTimeout = duration;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder responseTimeout(Duration duration) {
        this.responseTimeout = duration;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder writeTimeout(Duration duration) {
        this.writeTimeout = duration;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder connectionTimeout(Duration duration) {
        this.connectionTimeout = duration;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder callTimeout(Duration duration) {
        if (duration != null && duration.isNegative()) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'callTimeout' cannot be negative"));
        }
        this.callTimeout = duration;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder connectionPool(ConnectionPool connectionPool) {
        this.connectionPool = Objects.requireNonNull(connectionPool, "'connectionPool' cannot be null.");
        return this;
    }

    public OkHttpAsyncHttpClientBuilder dispatcher(Dispatcher dispatcher) {
        this.dispatcher = Objects.requireNonNull(dispatcher, "'dispatcher' cannot be null.");
        return this;
    }

    public OkHttpAsyncHttpClientBuilder proxy(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public OkHttpAsyncHttpClientBuilder followRedirects(boolean bl2) {
        this.followRedirects = bl2;
        return this;
    }

    public HttpClient build() {
        ProxyOptions proxyOptions;
        OkHttpClient.Builder builder = this.okHttpClient == null ? new OkHttpClient.Builder() : this.okHttpClient.newBuilder();
        for (Interceptor object2 : this.networkInterceptors) {
            builder = builder.addNetworkInterceptor(object2);
        }
        builder = builder.connectTimeout(HttpUtils.getTimeout(this.connectionTimeout, HttpUtils.getDefaultConnectTimeout())).writeTimeout(HttpUtils.getTimeout(this.writeTimeout, HttpUtils.getDefaultWriteTimeout())).readTimeout(HttpUtils.getTimeout(this.readTimeout, HttpUtils.getDefaultReadTimeout()));
        if (this.callTimeout != null) {
            builder.callTimeout(this.callTimeout);
        }
        if (this.connectionPool != null) {
            builder = builder.connectionPool(this.connectionPool);
        }
        if (this.dispatcher != null) {
            builder = builder.dispatcher(this.dispatcher);
        }
        Configuration configuration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        ProxyOptions proxyOptions2 = proxyOptions = this.proxyOptions == null ? ProxyOptions.fromConfiguration(configuration, true) : this.proxyOptions;
        if (proxyOptions != null) {
            builder = builder.proxySelector((ProxySelector)new OkHttpProxySelector(proxyOptions.getType().toProxyType(), proxyOptions::getAddress, proxyOptions.getNonProxyHosts()));
            if (proxyOptions.getUsername() != null) {
                ProxyAuthenticator proxyAuthenticator = new ProxyAuthenticator(proxyOptions.getUsername(), proxyOptions.getPassword());
                builder = builder.proxyAuthenticator((Authenticator)proxyAuthenticator).addInterceptor(proxyAuthenticator.getProxyAuthenticationInfoInterceptor());
            }
        }
        builder.followRedirects(this.followRedirects);
        return new OkHttpAsyncHttpClient(builder.build(), HttpUtils.getTimeout(this.responseTimeout, HttpUtils.getDefaultResponseTimeout()));
    }
}

