/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.okhttp;

import java.util.concurrent.TimeUnit;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpClient;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpClientProvider;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.okhttp.OkHttpAsyncHttpClientBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.HttpClientOptions;
import macromedia.jdbc.sqlserver.externals.okhttp3.ConnectionPool;

public final class OkHttpAsyncClientProvider
implements HttpClientProvider {
    private static final boolean AZURE_ENABLE_HTTP_CLIENT_SHARING = Configuration.getGlobalConfiguration().get("AZURE_ENABLE_HTTP_CLIENT_SHARING", Boolean.FALSE);
    private final boolean enableHttpClientSharing;

    public OkHttpAsyncClientProvider() {
        this.enableHttpClientSharing = AZURE_ENABLE_HTTP_CLIENT_SHARING;
    }

    OkHttpAsyncClientProvider(Configuration configuration) {
        this.enableHttpClientSharing = configuration.get("AZURE_ENABLE_HTTP_CLIENT_SHARING", Boolean.FALSE);
    }

    @Override
    public HttpClient createInstance() {
        if (this.enableHttpClientSharing) {
            return GlobalOkHttpClient.HTTP_CLIENT.getHttpClient();
        }
        return new OkHttpAsyncHttpClientBuilder().build();
    }

    @Override
    public HttpClient createInstance(HttpClientOptions httpClientOptions) {
        if (httpClientOptions == null) {
            return this.createInstance();
        }
        OkHttpAsyncHttpClientBuilder okHttpAsyncHttpClientBuilder = new OkHttpAsyncHttpClientBuilder();
        okHttpAsyncHttpClientBuilder = okHttpAsyncHttpClientBuilder.proxy(httpClientOptions.getProxyOptions()).configuration(httpClientOptions.getConfiguration()).connectionTimeout(httpClientOptions.getConnectTimeout()).writeTimeout(httpClientOptions.getWriteTimeout()).readTimeout(httpClientOptions.getReadTimeout());
        Integer n2 = httpClientOptions.getMaximumConnectionPoolSize();
        int n3 = n2 != null && n2 > 0 ? n2 : 5;
        ConnectionPool connectionPool = new ConnectionPool(n3, httpClientOptions.getConnectionIdleTimeout().toMillis(), TimeUnit.MILLISECONDS);
        okHttpAsyncHttpClientBuilder = okHttpAsyncHttpClientBuilder.connectionPool(connectionPool);
        return okHttpAsyncHttpClientBuilder.build();
    }

    private static enum GlobalOkHttpClient {
        HTTP_CLIENT(new OkHttpAsyncHttpClientBuilder().build());

        private final HttpClient httpClient;

        private GlobalOkHttpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
        }

        private HttpClient getHttpClient() {
            return this.httpClient;
        }
    }
}

