/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.BufferedHttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.BinaryDataHelper;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.FluxByteBufferContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.BinaryData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.FluxUtil;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public abstract class HttpResponse
implements Closeable {
    private final HttpRequest request;

    protected HttpResponse(HttpRequest httpRequest) {
        this.request = httpRequest;
    }

    public abstract int getStatusCode();

    @Deprecated
    public abstract String getHeaderValue(String var1);

    public String getHeaderValue(HttpHeaderName httpHeaderName) {
        return this.getHeaders().getValue(httpHeaderName);
    }

    public abstract HttpHeaders getHeaders();

    public abstract Flux<ByteBuffer> getBody();

    public BinaryData getBodyAsBinaryData() {
        String string = this.getHeaderValue(HttpHeaderName.CONTENT_LENGTH);
        Flux<ByteBuffer> flux = this.getBody();
        if (CoreUtils.isNullOrEmpty(string)) {
            return BinaryDataHelper.createBinaryData(new FluxByteBufferContent(flux));
        }
        try {
            return BinaryDataHelper.createBinaryData(new FluxByteBufferContent(flux, Long.parseLong(string)));
        }
        catch (NumberFormatException numberFormatException) {
            return BinaryDataHelper.createBinaryData(new FluxByteBufferContent(flux));
        }
    }

    public abstract Mono<byte[]> getBodyAsByteArray();

    public abstract Mono<String> getBodyAsString();

    public abstract Mono<String> getBodyAsString(Charset var1);

    public Mono<InputStream> getBodyAsInputStream() {
        return this.getBodyAsByteArray().map(ByteArrayInputStream::new);
    }

    public final HttpRequest getRequest() {
        return this.request;
    }

    public HttpResponse buffer() {
        return new BufferedHttpResponse(this);
    }

    public Mono<Void> writeBodyToAsync(AsynchronousByteChannel asynchronousByteChannel) {
        Objects.requireNonNull(asynchronousByteChannel, "'channel' must not be null");
        Flux<ByteBuffer> flux = this.getBody();
        if (flux != null) {
            return FluxUtil.writeToAsynchronousByteChannel(flux, asynchronousByteChannel);
        }
        return Mono.empty();
    }

    public void writeBodyTo(WritableByteChannel writableByteChannel) throws IOException {
        Flux<ByteBuffer> flux = this.getBody();
        if (flux != null) {
            Mono.using(() -> this, httpResponse -> FluxUtil.writeToWritableByteChannel(flux, writableByteChannel), HttpResponse::close).block();
        }
    }

    @Override
    public void close() {
    }
}

