/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ImplUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.BinaryDataHelper;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.FluxByteBufferContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.BinaryData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;

public class HttpRequest {
    private static final ClientLogger LOGGER = new ClientLogger(HttpRequest.class);
    private HttpMethod httpMethod;
    private URL url;
    private HttpHeaders headers;
    private BinaryData body;

    public HttpRequest(HttpMethod httpMethod, URL uRL) {
        this(httpMethod, uRL, new HttpHeaders(), (BinaryData)null);
    }

    public HttpRequest(HttpMethod httpMethod, String string) {
        this.httpMethod = httpMethod;
        this.setUrl(string);
        this.headers = new HttpHeaders();
    }

    public HttpRequest(HttpMethod httpMethod, URL uRL, HttpHeaders httpHeaders) {
        this.httpMethod = httpMethod;
        this.url = uRL;
        this.headers = httpHeaders;
    }

    public HttpRequest(HttpMethod httpMethod, URL uRL, HttpHeaders httpHeaders, Flux<ByteBuffer> flux) {
        this.httpMethod = httpMethod;
        this.url = uRL;
        this.headers = httpHeaders;
        this.setBody(BinaryDataHelper.createBinaryData(new FluxByteBufferContent(flux)));
    }

    public HttpRequest(HttpMethod httpMethod, URL uRL, HttpHeaders httpHeaders, BinaryData binaryData) {
        this.httpMethod = httpMethod;
        this.url = uRL;
        this.headers = httpHeaders;
        this.setBody(binaryData);
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public HttpRequest setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public URL getUrl() {
        return this.url;
    }

    public HttpRequest setUrl(URL uRL) {
        this.url = uRL;
        return this;
    }

    public HttpRequest setUrl(String string) {
        try {
            this.url = ImplUtils.createUrl(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw LOGGER.logExceptionAsWarning(new IllegalArgumentException("'url' must be a valid URL.", malformedURLException));
        }
        return this;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public HttpRequest setHeaders(HttpHeaders httpHeaders) {
        this.headers = httpHeaders;
        return this;
    }

    @Deprecated
    public HttpRequest setHeader(String string, String string2) {
        this.headers.set(string, string2);
        return this;
    }

    public HttpRequest setHeader(HttpHeaderName httpHeaderName, String string) {
        this.headers.set(httpHeaderName, string);
        return this;
    }

    public Flux<ByteBuffer> getBody() {
        return this.body == null ? null : this.body.toFluxByteBuffer();
    }

    public BinaryData getBodyAsBinaryData() {
        return this.body;
    }

    public HttpRequest setBody(String string) {
        return this.setBody(BinaryData.fromString(string));
    }

    public HttpRequest setBody(byte[] byArray) {
        return this.setBody(BinaryData.fromBytes(byArray));
    }

    public HttpRequest setBody(Flux<ByteBuffer> flux) {
        this.body = flux != null ? BinaryDataHelper.createBinaryData(new FluxByteBufferContent(flux)) : null;
        return this;
    }

    public HttpRequest setBody(BinaryData binaryData) {
        this.body = binaryData;
        if (binaryData != null && binaryData.getLength() != null) {
            this.setContentLength(binaryData.getLength());
        }
        return this;
    }

    private void setContentLength(long l2) {
        this.headers.set(HttpHeaderName.CONTENT_LENGTH, String.valueOf(l2));
    }

    public HttpRequest copy() {
        HttpHeaders httpHeaders = new HttpHeaders(this.headers);
        return new HttpRequest(this.httpMethod, this.url, httpHeaders, this.body);
    }
}

