/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpClient;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipeline;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelinePolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.UrlSanitizer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.policy.InstrumentationPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ClientOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.HttpClientOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.TracingOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.tracing.Tracer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.tracing.TracerProvider;

public class HttpPipelineBuilder {
    private HttpClient httpClient;
    private List<HttpPipelinePolicy> pipelinePolicies;
    private ClientOptions clientOptions;
    private Tracer tracer;

    public HttpPipeline build() {
        ArrayList<HttpPipelinePolicy> arrayList;
        List<Object> list = arrayList = this.pipelinePolicies == null ? new ArrayList() : this.pipelinePolicies;
        HttpClient httpClient = this.httpClient != null ? this.httpClient : (this.clientOptions instanceof HttpClientOptions ? HttpClient.createDefault((HttpClientOptions)this.clientOptions) : HttpClient.createDefault());
        this.configureTracing(arrayList, this.clientOptions);
        return new HttpPipeline(httpClient, arrayList, this.tracer);
    }

    private void configureTracing(List<HttpPipelinePolicy> list, ClientOptions clientOptions) {
        if (this.tracer == null) {
            TracingOptions tracingOptions = clientOptions == null ? null : clientOptions.getTracingOptions();
            this.tracer = TracerProvider.getDefaultProvider().createTracer("azure-core", null, null, tracingOptions);
        }
        for (HttpPipelinePolicy httpPipelinePolicy : list) {
            if (!(httpPipelinePolicy instanceof InstrumentationPolicy)) continue;
            UrlSanitizer urlSanitizer = new UrlSanitizer(HttpPipelineBuilder.getAllowedQueryParams(clientOptions));
            ((InstrumentationPolicy)httpPipelinePolicy).initialize(this.tracer, urlSanitizer);
        }
    }

    private static Set<String> getAllowedQueryParams(ClientOptions clientOptions) {
        if (clientOptions == null || clientOptions.getTracingOptions() == null) {
            return null;
        }
        return clientOptions.getTracingOptions().getAllowedTracingQueryParamNames();
    }

    public HttpPipelineBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public HttpPipelineBuilder policies(HttpPipelinePolicy ... httpPipelinePolicyArray) {
        if (this.pipelinePolicies == null) {
            this.pipelinePolicies = new ArrayList<HttpPipelinePolicy>();
        }
        this.pipelinePolicies.addAll(Arrays.asList(httpPipelinePolicyArray));
        return this;
    }

    public HttpPipelineBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public HttpPipelineBuilder tracer(Tracer tracer) {
        this.tracer = tracer;
        return this;
    }
}

