/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeader;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.HttpHeadersAccessHelper;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;

public class HttpHeaders
implements Iterable<HttpHeader> {
    private final Map<String, HttpHeader> headers;

    public HttpHeaders() {
        this.headers = new HashMap<String, HttpHeader>();
    }

    public HttpHeaders(Map<String, String> map) {
        this.headers = new HashMap<String, HttpHeader>(map.size());
        map.forEach(this::set);
    }

    public HttpHeaders(Iterable<HttpHeader> iterable) {
        this.headers = new HashMap<String, HttpHeader>();
        for (HttpHeader httpHeader : iterable) {
            this.set(httpHeader.getName(), httpHeader.getValuesList());
        }
    }

    HttpHeaders(HttpHeaders httpHeaders) {
        this.headers = new HashMap<String, HttpHeader>((int)((float)httpHeaders.headers.size() / 0.75f));
        httpHeaders.headers.forEach((? super K string, ? super V httpHeader) -> this.headers.put((String)string, new HttpHeader(httpHeader.getName(), httpHeader.getValuesList())));
    }

    public HttpHeaders(int n2) {
        this.headers = new HashMap<String, HttpHeader>(n2);
    }

    public int getSize() {
        return this.headers.size();
    }

    @Deprecated
    public HttpHeaders add(String string, String string2) {
        return this.addInternal(HttpHeaders.formatKey(string), string, string2);
    }

    public HttpHeaders add(HttpHeaderName httpHeaderName, String string) {
        return this.addInternal(httpHeaderName.getCaseInsensitiveName(), httpHeaderName.getCaseSensitiveName(), string);
    }

    private HttpHeaders addInternal(String string, String string2, String string4) {
        if (string2 == null || string4 == null) {
            return this;
        }
        this.headers.compute(string, (string3, httpHeader) -> {
            if (httpHeader == null) {
                return new HttpHeader(string2, string4);
            }
            httpHeader.addValue(string4);
            return httpHeader;
        });
        return this;
    }

    @Deprecated
    public HttpHeaders put(String string, String string2) {
        return this.set(string, string2);
    }

    @Deprecated
    public HttpHeaders set(String string, String string2) {
        return this.setInternal(HttpHeaders.formatKey(string), string, string2);
    }

    public HttpHeaders set(HttpHeaderName httpHeaderName, String string) {
        return this.setInternal(httpHeaderName.getCaseInsensitiveName(), httpHeaderName.getCaseSensitiveName(), string);
    }

    private HttpHeaders setInternal(String string, String string2, String string3) {
        if (string2 == null) {
            return this;
        }
        if (string3 == null) {
            this.removeInternal(string2);
        } else {
            this.headers.put(string, new HttpHeader(string2, string3));
        }
        return this;
    }

    @Deprecated
    public HttpHeaders set(String string, List<String> list) {
        return this.setInternal(HttpHeaders.formatKey(string), string, list);
    }

    public HttpHeaders set(HttpHeaderName httpHeaderName, List<String> list) {
        return this.setInternal(httpHeaderName.getCaseInsensitiveName(), httpHeaderName.getCaseSensitiveName(), list);
    }

    private HttpHeaders setInternal(String string, String string2, List<String> list) {
        if (string == null) {
            return this;
        }
        if (CoreUtils.isNullOrEmpty(list)) {
            this.removeInternal(string);
        } else {
            this.headers.put(string, new HttpHeader(string2, list));
        }
        return this;
    }

    public HttpHeaders setAll(Map<String, List<String>> map) {
        map.forEach(this::set);
        return this;
    }

    public HttpHeaders setAllHttpHeaders(HttpHeaders httpHeaders) {
        if (httpHeaders != null) {
            httpHeaders.headers.forEach((? super K string, ? super V httpHeader) -> this.setInternal((String)string, httpHeader.getName(), httpHeader.getValuesList()));
        }
        return this;
    }

    @Deprecated
    public HttpHeader get(String string) {
        return this.getInternal(HttpHeaders.formatKey(string));
    }

    public HttpHeader get(HttpHeaderName httpHeaderName) {
        return this.getInternal(httpHeaderName.getCaseInsensitiveName());
    }

    private HttpHeader getInternal(String string) {
        return this.headers.get(string);
    }

    @Deprecated
    public HttpHeader remove(String string) {
        return this.removeInternal(HttpHeaders.formatKey(string));
    }

    public HttpHeader remove(HttpHeaderName httpHeaderName) {
        return this.removeInternal(httpHeaderName.getCaseInsensitiveName());
    }

    private HttpHeader removeInternal(String string) {
        return this.headers.remove(string);
    }

    @Deprecated
    public String getValue(String string) {
        return this.getValueInternal(HttpHeaders.formatKey(string));
    }

    public String getValue(HttpHeaderName httpHeaderName) {
        return this.getValueInternal(httpHeaderName.getCaseInsensitiveName());
    }

    private String getValueInternal(String string) {
        HttpHeader httpHeader = this.getInternal(string);
        return httpHeader == null ? null : httpHeader.getValue();
    }

    @Deprecated
    public String[] getValues(String string) {
        return this.getValuesInternal(HttpHeaders.formatKey(string));
    }

    public String[] getValues(HttpHeaderName httpHeaderName) {
        return this.getValuesInternal(httpHeaderName.getCaseInsensitiveName());
    }

    private String[] getValuesInternal(String string) {
        HttpHeader httpHeader = this.getInternal(string);
        return httpHeader == null ? null : httpHeader.getValues();
    }

    public Map<String, String> toMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (HttpHeader httpHeader : this.headers.values()) {
            hashMap.put(httpHeader.getName(), httpHeader.getValue());
        }
        return Collections.unmodifiableMap(hashMap);
    }

    Map<String, String[]> toMultiMap() {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        for (HttpHeader httpHeader : this.headers.values()) {
            hashMap.put(httpHeader.getName(), httpHeader.getValues());
        }
        return Collections.unmodifiableMap(hashMap);
    }

    @Override
    public Iterator<HttpHeader> iterator() {
        return this.headers.values().iterator();
    }

    public Stream<HttpHeader> stream() {
        return this.headers.values().stream();
    }

    public String toString() {
        return this.stream().map(httpHeader -> httpHeader.getName() + "=" + httpHeader.getValue()).collect(Collectors.joining(", "));
    }

    private static String formatKey(String string) {
        return string == null ? null : string.toLowerCase(Locale.ROOT);
    }

    static {
        HttpHeadersAccessHelper.setAccessor(new HttpHeadersAccessHelper.HttpHeadersAccessor(){

            @Override
            public Map<String, HttpHeader> getRawHeaderMap(HttpHeaders httpHeaders) {
                return httpHeaders.headers;
            }

            @Override
            public void addInternal(HttpHeaders httpHeaders, String string, String string2, String string3) {
                httpHeaders.addInternal(string, string2, string3);
            }

            @Override
            public void setInternal(HttpHeaders httpHeaders, String string, String string2, List<String> list) {
                httpHeaders.setInternal(string, string2, list);
            }
        });
    }
}

