/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.credential;

import java.util.Objects;
import java.util.function.Function;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public final class AzureSasCredential {
    private static final ClientLogger LOGGER = new ClientLogger(AzureSasCredential.class);
    private final Function<String, String> signatureEncoder;
    private volatile String signature;

    public AzureSasCredential(String string) {
        this(string, null);
    }

    public AzureSasCredential(String string, Function<String, String> function) {
        Objects.requireNonNull(string, "'signature' cannot be null.");
        if (string.isEmpty()) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'signature' cannot be empty."));
        }
        this.signatureEncoder = function;
        this.signature = function == null ? string : function.apply(string);
    }

    public String getSignature() {
        return this.signature;
    }

    public AzureSasCredential update(String string) {
        Objects.requireNonNull(string, "'signature' cannot be null.");
        if (string.isEmpty()) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'signature' cannot be empty."));
        }
        this.signature = this.signatureEncoder == null ? string : this.signatureEncoder.apply(string);
        return this;
    }
}

