/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.credential;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AzureNamedKey;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public final class AzureNamedKeyCredential {
    private static final ClientLogger LOGGER = new ClientLogger(AzureNamedKeyCredential.class);
    private volatile AzureNamedKey credentials;

    public AzureNamedKeyCredential(String string, String string2) {
        this.validateInputParameters(string, string2);
        this.credentials = new AzureNamedKey(string, string2);
    }

    public AzureNamedKey getAzureNamedKey() {
        return this.credentials;
    }

    public AzureNamedKeyCredential update(String string, String string2) {
        this.validateInputParameters(string, string2);
        this.credentials = new AzureNamedKey(string, string2);
        return this;
    }

    private void validateInputParameters(String string, String string2) {
        Objects.requireNonNull(string, "'name' cannot be null.");
        Objects.requireNonNull(string2, "'key' cannot be null.");
        if (string.isEmpty()) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'name' cannot be empty."));
        }
        if (string2.isEmpty()) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'key' cannot be empty."));
        }
    }
}

