/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.search;

import coldfusion.lucene.SolrServiceImpl;
import coldfusion.runtime.Struct;
import coldfusion.search.exceptions.SearchExceptions;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.search.SolrUtils;
import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.solr.client.solrj.SolrServerException;

public class SearchTag
extends GenericTag {
    private static final GenericTagPermission tp = new GenericTagPermission("cfsearch");
    private String name;
    private String collection;
    private String criteria = "";
    private String type = "Simple";
    private int maxrows = 0;
    private int startrow = 1;
    private String language = null;
    private String status = null;
    private String previousCriteria = null;
    private int contextPassages = 0;
    private int contextBytes = 300;
    private String contextHighlightBegin = "<b>";
    private String contextHighlightEnd = "</b>";
    private int suggestionThreshold = -2;
    private String category = null;
    private String categoryTree = null;
    private static final int SUGGESTION_ALWAYS = -1;
    private static final int SUGGESTION_NEVER = -2;
    private static final String RANK = "rank";
    private static final String[] QueryColumns = new String[]{"SCORE", "KEY", "TITLE", "CUSTOM1", "CUSTOM2", "CUSTOM3", "CUSTOM4", "URL", "SUMMARY", "CONTEXT", "RECORDSSEARCHED", "SIZE", "RANK", "AUTHOR", "TYPE", "CATEGORY", "CATEGORYTREE"};
    private SolrServiceImpl solrService;
    private String solrurl;
    private ArrayList<String> collectionList = new ArrayList();
    private static final int MAX_DOCS = 100000;
    private String orderby;
    private String searchtime;
    private String searchcolumns;
    private Set<String> searchColList = new HashSet<String>();

    public void release() {
        this.name = null;
        this.collection = null;
        this.criteria = "";
        this.type = "Simple";
        this.maxrows = 0;
        this.startrow = 1;
        this.language = null;
        this.status = null;
        this.previousCriteria = null;
        this.contextPassages = 0;
        this.contextBytes = 300;
        this.contextHighlightBegin = "<b>";
        this.contextHighlightEnd = "</b>";
        this.suggestionThreshold = -2;
        this.category = null;
        this.categoryTree = null;
        this.solrService = null;
        this.collectionList.clear();
        this.orderby = null;
        this.onTagEnd();
        super.release();
    }

    public int doStartTag() {
        this.onTagStart();
        this.solrService = (SolrServiceImpl)ServiceFactory.getSolrService();
        this.solrurl = SolrUtils.getSolrURL(this.solrService);
        if (!(this.category != null && this.category.length() != 0 || this.categoryTree != null && this.categoryTree.length() != 0)) {
            this.doSearch();
        } else {
            this.doCategorySearch();
        }
        return 0;
    }

    private void doSearch() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.collection, "\t\n,");
        ArrayList<String> sArray = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String collectionName = stringTokenizer.nextToken().trim();
            if (SolrUtils.isSolrRunning(this.solrurl)) {
                if (SolrUtils.isSolrCore(this.solrurl, collectionName)) {
                    sArray.add(SolrUtils.fixURL(collectionName));
                    continue;
                }
                throw new SearchExceptions.CollectionDoesNotExistException(collectionName);
            }
            throw new SearchExceptions.SolrNotRunning(this.solrurl);
        }
        int sindex = sArray.size();
        Object verityQuery = null;
        QueryTable solrQuery = null;
        Object status_struct_v = null;
        Object status_struct_l = null;
        Struct status_struct_s = null;
        if (sindex > 0) {
            try {
                Map<String, Object> searchresult = this.doSolrSearch(this.solrurl, sArray);
                solrQuery = (QueryTable)searchresult.get("RESULT");
                if (this.status != null && searchresult.containsKey("STATUS")) {
                    status_struct_s = (Struct)searchresult.get("STATUS");
                }
            }
            catch (SearchExceptions.SearchProblemException e) {
                throw e;
            }
            catch (IOException | SolrServerException e) {
                throw new SearchExceptions.SearchProblemException(e.getMessage());
            }
        }
        List<String> fixFieldNames = Arrays.asList(QueryColumns);
        List<Object> allFieldNames = new LinkedList<String>();
        allFieldNames.addAll(fixFieldNames);
        int colLength = 0;
        if (solrQuery.getRecordCount() > 0) {
            colLength = solrQuery.getCol_count();
            allFieldNames = new LinkedList<String>(Arrays.asList(solrQuery.getColumnNames()));
        } else {
            allFieldNames = Arrays.asList(QueryColumns);
            colLength = QueryColumns.length;
        }
        int[] columnTypes = new int[colLength];
        String[] columnTypeNames = new String[colLength];
        for (int j = 0; j < colLength; ++j) {
            columnTypes[j] = 12;
            columnTypeNames[j] = "VARCHAR";
        }
        QueryTable resultQuery = new QueryTable(0, allFieldNames.toArray(new String[allFieldNames.size()]), columnTypeNames, columnTypes);
        if (this.status != null) {
            Struct status_struct = new Struct();
            int records = 0;
            int found = 0;
            int time = 0;
            String suggestedquery = "";
            Struct keywords = new Struct();
            Struct keywordsscore = new Struct();
            if (status_struct_s != null) {
                records += new Integer(status_struct_s.get((Object)"SEARCHED").toString()).intValue();
                time += new Integer(status_struct_s.get((Object)"TIME").toString()).intValue();
                if (this.suggestionThreshold == -1 || (found += new Integer(status_struct_s.get((Object)"FOUND").toString()).intValue()) < this.suggestionThreshold) {
                    suggestedquery = status_struct_s.get((Object)"SUGGESTEDQUERY").toString();
                    String collatedresult = status_struct_s.get((Object)"COLLATEDRESULT").toString();
                    status_struct.put((Object)"SUGGESTEDQUERY", (Object)suggestedquery);
                    status_struct.put((Object)"COLLATEDRESULT", (Object)collatedresult);
                    if (status_struct_s.get((Object)"KEYWORDS") != null) {
                        status_struct.put((Object)"KEYWORDS", status_struct_s.get((Object)"KEYWORDS"));
                    }
                }
            }
            status_struct.put((Object)"SEARCHED", (Object)records);
            status_struct.put((Object)"FOUND", (Object)found);
            status_struct.put((Object)"TIME", (Object)time);
            this.pageContext.setAttribute(this.status, (Object)status_struct);
        }
        try {
            if (solrQuery != null) {
                resultQuery.populate(solrQuery, solrQuery.getMaxRows());
            }
            this.pageContext.setAttribute(this.name, (Object)resultQuery);
        }
        catch (Exception e) {
            throw new SearchExceptions.SearchProblemException(e.getMessage());
        }
    }

    private Map<String, Object> doSolrSearch(String url, ArrayList<String> collections) throws SolrServerException, IOException {
        long foundrecords = 0L;
        int numrecords = 0;
        HashMap<String, Object> resultmap = new HashMap<String, Object>();
        boolean suggest = false;
        Object suggestions = "";
        Object collations = "";
        ArrayList<HashMap> suggestionlist = new ArrayList<HashMap>();
        Map<String, Object> retval = null;
        ArrayList<HashMap[]> results = new ArrayList<HashMap[]>();
        int totalcount = 0;
        long executiontime = 0L;
        StringBuilder collectionNames = new StringBuilder();
        for (String collection : collections) {
            collectionNames.append(collection).append(",");
        }
        collectionNames.deleteCharAt(collectionNames.length() - 1);
        int totalcollectioncount = SolrUtils.getSolrDocCount(url, collectionNames.toString());
        if (this.maxrows == 0) {
            this.maxrows = totalcollectioncount;
        }
        if (this.suggestionThreshold != -2) {
            suggest = true;
        }
        String querytype = this.type.equals("Simple") ? "standard" : this.type;
        if (this.previousCriteria == null) {
            this.previousCriteria = "";
        }
        retval = this.contextPassages > 0 ? SolrUtils.getSearchResult(url, collectionNames.toString(), this.criteria, this.previousCriteria, this.startrow, this.maxrows, this.contextHighlightBegin, this.contextHighlightEnd, this.category, this.categoryTree, querytype, this.language, this.contextPassages, this.contextBytes, suggest, this.orderby, this.searchtime, this.searchcolumns, totalcollectioncount) : SolrUtils.getSearchResult(url, collectionNames.toString(), this.criteria, this.previousCriteria, this.category, this.categoryTree, querytype, this.language, this.startrow, this.maxrows, suggest, this.orderby, this.searchtime, this.searchcolumns, totalcollectioncount);
        ArrayList solrresult = (ArrayList)retval.get("RESULT");
        HashMap suggmap = (HashMap)retval.get("SUGGESTMAP");
        if (suggmap != null) {
            suggestionlist.add(suggmap);
        }
        HashMap[] m = new HashMap[solrresult.size()];
        solrresult.toArray(m);
        results.add(m);
        totalcount += m.length;
        numrecords += totalcollectioncount;
        foundrecords += ((Long)retval.get("NUMFOUND")).longValue();
        executiontime += ((Long)retval.get("EXECUTION_TIME")).longValue();
        List<String> extraFieldList = this.getCustomFields();
        List<String> fixFieldNames = Arrays.asList(QueryColumns);
        List<Object> allFieldNames = new LinkedList<String>();
        allFieldNames.addAll(fixFieldNames);
        int colLength = 0;
        allFieldNames.addAll(extraFieldList);
        if (((Map[])results.get(0)).length > 0) {
            allFieldNames = this.mergeAllFieldNames((Map[])results.get(0));
            if (this.isRankRequired()) {
                allFieldNames.add(RANK.toUpperCase());
            }
            colLength = allFieldNames.size();
        } else {
            allFieldNames = Arrays.asList(QueryColumns);
            colLength = QueryColumns.length;
        }
        int[] columnTypes = new int[colLength];
        String[] columnTypeNames = new String[colLength];
        for (int j = 0; j < colLength; ++j) {
            columnTypes[j] = 12;
            columnTypeNames[j] = "VARCHAR";
        }
        QueryTable resultQuery = new QueryTable(totalcount, allFieldNames.toArray(new String[allFieldNames.size()]), columnTypeNames, columnTypes);
        int queryrow = 1;
        for (int l = 0; l < results.size(); ++l) {
            Map[] m2;
            for (Map map : m2 = (Map[])results.get(l)) {
                int col = 1;
                for (Map.Entry entry : map.entrySet()) {
                    String fieldValue = (String)entry.getValue();
                    resultQuery.setField(queryrow, this.getColumnNumber((String)entry.getKey(), allFieldNames), (Object)fieldValue);
                    ++col;
                }
                if (this.isRankRequired()) {
                    int rank = queryrow + (this.startrow - 1);
                    resultQuery.setField(queryrow, allFieldNames.size(), (Object)rank);
                }
                ++queryrow;
            }
        }
        if (this.status != null) {
            Struct status_struct = new Struct();
            status_struct.put((Object)"SEARCHED", (Object)new Long(numrecords));
            status_struct.put((Object)"FOUND", (Object)foundrecords);
            status_struct.put((Object)"TIME", (Object)executiontime);
            if (suggest && suggestionlist.size() > 0) {
                for (HashMap s : suggestionlist) {
                    suggestions = (String)suggestions + (String)s.get("SUGGESTIONS") + " ";
                    collations = (String)collations + (String)s.get("COLLATIONS") + " ";
                    status_struct.put((Object)"KEYWORDS", s.get("KEYWORDS"));
                }
            }
            status_struct.put((Object)"SUGGESTEDQUERY", (Object)((String)suggestions).trim());
            status_struct.put((Object)"COLLATEDRESULT", collations);
            resultmap.put("STATUS", status_struct);
        }
        resultmap.put("RESULT", resultQuery);
        return resultmap;
    }

    private boolean isRankRequired() {
        return this.searchColList.contains(RANK) || this.searchColList.contains("*") || this.searchColList.size() == 0;
    }

    private int getColumnNumber(String key, List<String> allFieldNames) {
        int pos = 1;
        for (String colName : allFieldNames) {
            if (key.equalsIgnoreCase(colName)) break;
            ++pos;
        }
        return pos;
    }

    private List<String> mergeAllFieldNames(Map[] maps) {
        HashSet<String> fieldNames = new HashSet<String>();
        for (Map map : maps) {
            for (String fieldName : map.keySet()) {
                fieldNames.add(fieldName);
            }
        }
        return new LinkedList<String>(fieldNames);
    }

    private List<String> getCustomFields() {
        String[] criterias = this.criteria.split(",");
        LinkedList<String> extraFieldList = new LinkedList<String>();
        for (String crit : criterias) {
            if (crit.indexOf(58) < 0) continue;
            String customFieldName = crit.split(":")[0];
            extraFieldList.add(customFieldName.toUpperCase());
        }
        return extraFieldList;
    }

    private String getHighlightedSummary(String summary) {
        String regex = "(?i)\\b\\p{Alpha}*" + this.criteria + "\\p{Alpha}*\\b";
        return summary.replaceAll(regex, "<STRONG>$0</STRONG>");
    }

    private void doCategorySearch() {
        this.doSearch();
    }

    protected Permission getPermission() {
        return tp;
    }

    public void setCollection(String a) {
        this.collection = a;
    }

    public void setOrderby(String order) {
        this.orderby = order.toLowerCase();
    }

    public void setSearchtime(String time) {
        this.searchtime = time.trim().toLowerCase();
    }

    public void setName(String a) {
        this.name = a;
    }

    public void setType(String a) {
        this.type = a.toLowerCase();
    }

    public void setCriteria(String a) {
        this.criteria = a;
    }

    public void setPreviousCriteria(String a) {
        this.previousCriteria = a;
    }

    public void setMaxrows(int a) {
        this.maxrows = a;
    }

    public void setStartrow(int a) {
        this.startrow = a;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setStatus(String s) {
        this.status = s;
    }

    public void setContextPassages(int n) {
        this.contextPassages = n;
    }

    public void setContextBytes(int n) {
        this.contextBytes = n;
    }

    public void setContextHighlightBegin(String s) {
        this.contextHighlightBegin = s;
    }

    public void setContextHighlightEnd(String s) {
        this.contextHighlightEnd = s;
    }

    public void setSuggestions(String s) {
        if ("ALWAYS".equalsIgnoreCase(s)) {
            this.suggestionThreshold = -1;
        } else if ("NEVER".equalsIgnoreCase(s)) {
            this.suggestionThreshold = -2;
        } else {
            int x;
            try {
                x = Integer.parseInt(s);
                if (x < 0) {
                    throw new SearchExceptions.BadSuggestionException(s);
                }
            }
            catch (NumberFormatException e) {
                throw new SearchExceptions.BadSuggestionException(s);
            }
            this.suggestionThreshold = x;
        }
    }

    public void setCategory(String s) {
        this.category = s;
    }

    public void setCategorytree(String s) {
        this.categoryTree = s;
    }

    public void setSearchcolumns(String searchcolumns) {
        this.searchcolumns = searchcolumns;
        if (SolrUtils.stringNullCheck(searchcolumns)) {
            String[] split;
            for (String s : split = searchcolumns.split(",")) {
                this.searchColList.add(s);
            }
        }
    }

    public String getSearchcolumns() {
        return this.searchcolumns;
    }
}

