/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.mixed;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.fuseable.SimplePlainQueue;
import io.reactivex.rxjava3.internal.queue.SpscArrayQueue;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

public final class FlowableConcatMapCompletable<T>
extends Completable {
    final Flowable<T> source;
    final Function<? super T, ? extends CompletableSource> mapper;
    final ErrorMode errorMode;
    final int prefetch;

    public FlowableConcatMapCompletable(Flowable<T> source2, Function<? super T, ? extends CompletableSource> mapper, ErrorMode errorMode, int prefetch) {
        this.source = source2;
        this.mapper = mapper;
        this.errorMode = errorMode;
        this.prefetch = prefetch;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        this.source.subscribe((FlowableSubscriber<? super T>)new ConcatMapCompletableObserver<T>(observer, this.mapper, this.errorMode, this.prefetch));
    }

    static final class ConcatMapCompletableObserver<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Disposable {
        private static final long serialVersionUID = 3610901111000061034L;
        final CompletableObserver downstream;
        final Function<? super T, ? extends CompletableSource> mapper;
        final ErrorMode errorMode;
        final AtomicThrowable errors;
        final ConcatMapInnerObserver inner;
        final int prefetch;
        final SimplePlainQueue<T> queue;
        Subscription upstream;
        volatile boolean active;
        volatile boolean done;
        volatile boolean disposed;
        int consumed;

        ConcatMapCompletableObserver(CompletableObserver downstream, Function<? super T, ? extends CompletableSource> mapper, ErrorMode errorMode, int prefetch) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.errorMode = errorMode;
            this.prefetch = prefetch;
            this.errors = new AtomicThrowable();
            this.inner = new ConcatMapInnerObserver(this);
            this.queue = new SpscArrayQueue<T>(prefetch);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
                s.request(this.prefetch);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.queue.offer(t)) {
                this.drain();
            } else {
                this.upstream.cancel();
                this.onError(new MissingBackpressureException("Queue full?!"));
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.errors.tryAddThrowableOrReport(t)) {
                if (this.errorMode == ErrorMode.IMMEDIATE) {
                    this.inner.dispose();
                    this.errors.tryTerminateConsumer(this.downstream);
                    if (this.getAndIncrement() == 0) {
                        this.queue.clear();
                    }
                } else {
                    this.done = true;
                    this.drain();
                }
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.upstream.cancel();
            this.inner.dispose();
            this.errors.tryTerminateAndReport();
            if (this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        void innerError(Throwable ex) {
            if (this.errors.tryAddThrowableOrReport(ex)) {
                if (this.errorMode == ErrorMode.IMMEDIATE) {
                    this.upstream.cancel();
                    this.errors.tryTerminateConsumer(this.downstream);
                    if (this.getAndIncrement() == 0) {
                        this.queue.clear();
                    }
                } else {
                    this.active = false;
                    this.drain();
                }
            }
        }

        void innerComplete() {
            this.active = false;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            do {
                CompletableSource cs;
                boolean empty;
                if (this.disposed) {
                    this.queue.clear();
                    return;
                }
                if (this.active) continue;
                if (this.errorMode == ErrorMode.BOUNDARY && this.errors.get() != null) {
                    this.queue.clear();
                    this.errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                boolean d = this.done;
                T v = this.queue.poll();
                boolean bl = empty = v == null;
                if (d && empty) {
                    this.errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                if (empty) continue;
                int c = this.consumed + 1;
                int limit = this.prefetch - (this.prefetch >> 1);
                if (c == limit) {
                    this.consumed = 0;
                    this.upstream.request(limit);
                } else {
                    this.consumed = c;
                }
                try {
                    cs = Objects.requireNonNull(this.mapper.apply(v), "The mapper returned a null CompletableSource");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.queue.clear();
                    this.upstream.cancel();
                    this.errors.tryAddThrowableOrReport(ex);
                    this.errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                this.active = true;
                cs.subscribe(this.inner);
            } while (this.decrementAndGet() != 0);
        }

        static final class ConcatMapInnerObserver
        extends AtomicReference<Disposable>
        implements CompletableObserver {
            private static final long serialVersionUID = 5638352172918776687L;
            final ConcatMapCompletableObserver<?> parent;

            ConcatMapInnerObserver(ConcatMapCompletableObserver<?> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.replace(this, d);
            }

            @Override
            public void onError(Throwable e) {
                this.parent.innerError(e);
            }

            @Override
            public void onComplete() {
                this.parent.innerComplete();
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

