/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.interceptor;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ScalarTypeAdapters;
import com.apollographql.apollo.api.cache.http.HttpCache;
import com.apollographql.apollo.api.internal.ApolloLogger;
import com.apollographql.apollo.api.internal.ResponseFieldMapper;
import com.apollographql.apollo.cache.normalized.internal.ResponseNormalizer;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloParseException;
import com.apollographql.apollo.http.OkHttpExecutionContext;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.response.OperationResponseParser;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.Executor;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public final class ApolloParseInterceptor
implements ApolloInterceptor {
    private final HttpCache httpCache;
    private final ResponseNormalizer<Map<String, Object>> normalizer;
    private final ResponseFieldMapper responseFieldMapper;
    private final ScalarTypeAdapters scalarTypeAdapters;
    private final ApolloLogger logger;
    volatile boolean disposed;

    public ApolloParseInterceptor(HttpCache httpCache, ResponseNormalizer<Map<String, Object>> normalizer, ResponseFieldMapper responseFieldMapper, ScalarTypeAdapters scalarTypeAdapters, ApolloLogger logger) {
        this.httpCache = httpCache;
        this.normalizer = normalizer;
        this.responseFieldMapper = responseFieldMapper;
        this.scalarTypeAdapters = scalarTypeAdapters;
        this.logger = logger;
    }

    @Override
    public void interceptAsync(final @NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptorChain chain, @NotNull Executor dispatcher, final @NotNull ApolloInterceptor.CallBack callBack) {
        if (this.disposed) {
            return;
        }
        chain.proceedAsync(request, dispatcher, new ApolloInterceptor.CallBack(){

            @Override
            public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                try {
                    if (ApolloParseInterceptor.this.disposed) {
                        return;
                    }
                    ApolloInterceptor.InterceptorResponse result = ApolloParseInterceptor.this.parse(request.operation, response.httpResponse.get());
                    callBack.onResponse(result);
                    callBack.onCompleted();
                }
                catch (ApolloException e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(@NotNull ApolloException e) {
                if (ApolloParseInterceptor.this.disposed) {
                    return;
                }
                callBack.onFailure(e);
            }

            @Override
            public void onCompleted() {
            }

            @Override
            public void onFetch(ApolloInterceptor.FetchSourceType sourceType) {
                callBack.onFetch(sourceType);
            }
        });
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    ApolloInterceptor.InterceptorResponse parse(Operation operation, Response httpResponse) throws ApolloHttpException, ApolloParseException {
        String cacheKey = httpResponse.request().header("X-APOLLO-CACHE-KEY");
        if (httpResponse.isSuccessful()) {
            try {
                OperationResponseParser parser2 = new OperationResponseParser(operation, this.responseFieldMapper, this.scalarTypeAdapters, this.normalizer);
                OkHttpExecutionContext httpExecutionContext = new OkHttpExecutionContext(httpResponse);
                com.apollographql.apollo.api.Response parsedResponse = parser2.parse(httpResponse.body().source());
                parsedResponse = parsedResponse.toBuilder().fromCache(httpResponse.cacheResponse() != null).executionContext(parsedResponse.getExecutionContext().plus(httpExecutionContext)).build();
                if (parsedResponse.hasErrors() && this.httpCache != null) {
                    this.httpCache.removeQuietly(cacheKey);
                }
                return new ApolloInterceptor.InterceptorResponse(httpResponse, parsedResponse, this.normalizer.records());
            }
            catch (Exception rethrown) {
                this.logger.e(rethrown, "Failed to parse network response for operation: %s", operation.name().name());
                ApolloParseInterceptor.closeQuietly(httpResponse);
                if (this.httpCache != null) {
                    this.httpCache.removeQuietly(cacheKey);
                }
                throw new ApolloParseException("Failed to parse http response", rethrown);
            }
        }
        this.logger.e("Failed to parse network response: %s", httpResponse);
        throw new ApolloHttpException(httpResponse);
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

