/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.interceptor;

import com.apollographql.apollo.api.Error;
import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.internal.ApolloLogger;
import com.apollographql.apollo.api.internal.Function;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.interceptor.ApolloInterceptorFactory;
import java.util.List;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApolloAutoPersistedOperationInterceptor
implements ApolloInterceptor {
    private static final String PROTOCOL_NEGOTIATION_ERROR_QUERY_NOT_FOUND = "PersistedQueryNotFound";
    private static final String PROTOCOL_NEGOTIATION_ERROR_NOT_SUPPORTED = "PersistedQueryNotSupported";
    private final ApolloLogger logger;
    private volatile boolean disposed;
    final boolean useHttpGetMethodForPersistedOperations;

    public ApolloAutoPersistedOperationInterceptor(@NotNull ApolloLogger logger, boolean useHttpGetMethodForPersistedOperations) {
        this.logger = logger;
        this.useHttpGetMethodForPersistedOperations = useHttpGetMethodForPersistedOperations;
    }

    @Override
    public void interceptAsync(final @NotNull ApolloInterceptor.InterceptorRequest request, final @NotNull ApolloInterceptorChain chain, final @NotNull Executor dispatcher, final @NotNull ApolloInterceptor.CallBack callBack) {
        ApolloInterceptor.InterceptorRequest newRequest = request.toBuilder().sendQueryDocument(false).autoPersistQueries(true).useHttpGetMethodForQueries(request.useHttpGetMethodForQueries || this.useHttpGetMethodForPersistedOperations).build();
        chain.proceedAsync(newRequest, dispatcher, new ApolloInterceptor.CallBack(){

            @Override
            public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                if (ApolloAutoPersistedOperationInterceptor.this.disposed) {
                    return;
                }
                Optional<ApolloInterceptor.InterceptorRequest> retryRequest = ApolloAutoPersistedOperationInterceptor.this.handleProtocolNegotiation(request, response);
                if (retryRequest.isPresent()) {
                    chain.proceedAsync(retryRequest.get(), dispatcher, callBack);
                } else {
                    callBack.onResponse(response);
                    callBack.onCompleted();
                }
            }

            @Override
            public void onFetch(ApolloInterceptor.FetchSourceType sourceType) {
                callBack.onFetch(sourceType);
            }

            @Override
            public void onFailure(@NotNull ApolloException e) {
                callBack.onFailure(e);
            }

            @Override
            public void onCompleted() {
            }
        });
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    Optional<ApolloInterceptor.InterceptorRequest> handleProtocolNegotiation(final ApolloInterceptor.InterceptorRequest request, ApolloInterceptor.InterceptorResponse response) {
        return response.parsedResponse.flatMap(new Function<Response, Optional<ApolloInterceptor.InterceptorRequest>>(){

            @Override
            @NotNull
            public Optional<ApolloInterceptor.InterceptorRequest> apply(@NotNull Response response) {
                if (response.hasErrors()) {
                    if (ApolloAutoPersistedOperationInterceptor.this.isPersistedQueryNotFound(response.getErrors())) {
                        ApolloAutoPersistedOperationInterceptor.this.logger.w("GraphQL server couldn't find Automatic Persisted Query for operation name: " + request.operation.name().name() + " id: " + request.operation.operationId(), new Object[0]);
                        ApolloInterceptor.InterceptorRequest retryRequest = request.toBuilder().autoPersistQueries(true).sendQueryDocument(true).build();
                        return Optional.of(retryRequest);
                    }
                    if (ApolloAutoPersistedOperationInterceptor.this.isPersistedQueryNotSupported(response.getErrors())) {
                        ApolloAutoPersistedOperationInterceptor.this.logger.e("GraphQL server doesn't support Automatic Persisted Queries", new Object[0]);
                        return Optional.of(request);
                    }
                }
                return Optional.absent();
            }
        });
    }

    boolean isPersistedQueryNotFound(List<Error> errors) {
        for (Error error : errors) {
            if (!PROTOCOL_NEGOTIATION_ERROR_QUERY_NOT_FOUND.equalsIgnoreCase(error.getMessage())) continue;
            return true;
        }
        return false;
    }

    boolean isPersistedQueryNotSupported(List<Error> errors) {
        for (Error error : errors) {
            if (!PROTOCOL_NEGOTIATION_ERROR_NOT_SUPPORTED.equalsIgnoreCase(error.getMessage())) continue;
            return true;
        }
        return false;
    }

    public static class Factory
    implements ApolloInterceptorFactory {
        final boolean useHttpGet;
        final boolean persistQueries;
        final boolean persistMutations;

        public Factory(boolean useHttpGet, boolean persistQueries, boolean persistMutations) {
            this.useHttpGet = useHttpGet;
            this.persistQueries = persistQueries;
            this.persistMutations = persistMutations;
        }

        public Factory() {
            this(false, true, true);
        }

        @Override
        @Nullable
        public ApolloInterceptor newInterceptor(@NotNull ApolloLogger logger, @NotNull Operation<?, ?, ?> operation) {
            if (operation instanceof Query && !this.persistQueries) {
                return null;
            }
            if (operation instanceof Mutation && !this.persistMutations) {
                return null;
            }
            return new ApolloAutoPersistedOperationInterceptor(logger, this.useHttpGet);
        }
    }
}

