/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized;

import com.apollographql.apollo.exception.ApolloException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0007\b&\u0018\u0000 \u0018*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\u0017\u0018B\u000f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\f2\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\bH\u0016J\u000b\u0010\u000e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0013\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\r\u0010\u0016\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u000fR\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/apollographql/apollo/cache/normalized/ApolloStoreOperation;", "T", "", "dispatcher", "Ljava/util/concurrent/Executor;", "(Ljava/util/concurrent/Executor;)V", "callback", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/apollographql/apollo/cache/normalized/ApolloStoreOperation$Callback;", "executed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "checkIfExecuted", "", "enqueue", "execute", "()Ljava/lang/Object;", "notifyFailure", "t", "", "notifySuccess", "result", "(Ljava/lang/Object;)V", "perform", "Callback", "Companion", "apollo-normalized-cache"})
public abstract class ApolloStoreOperation<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Executor dispatcher;
    @NotNull
    private final AtomicReference<Callback<T>> callback;
    @NotNull
    private final AtomicBoolean executed;

    protected ApolloStoreOperation(@NotNull Executor dispatcher) {
        Intrinsics.checkParameterIsNotNull(dispatcher, "dispatcher");
        this.dispatcher = dispatcher;
        this.callback = new AtomicReference();
        this.executed = new AtomicBoolean();
    }

    protected abstract T perform();

    public final T execute() throws ApolloException {
        T t;
        this.checkIfExecuted();
        try {
            t = this.perform();
        }
        catch (Exception e) {
            throw new ApolloException("Failed to perform store operation", e);
        }
        return t;
    }

    public void enqueue(@Nullable Callback<T> callback) {
        this.checkIfExecuted();
        this.callback.set(callback);
        this.dispatcher.execute(() -> ApolloStoreOperation.enqueue$lambda-0(this));
    }

    public final void notifySuccess(T result) {
        Callback callback = this.callback.getAndSet(null);
        if (callback == null) {
            return;
        }
        Callback callback2 = callback;
        callback2.onSuccess(result);
    }

    public final void notifyFailure(@NotNull Throwable t) {
        Intrinsics.checkParameterIsNotNull(t, "t");
        Callback callback = this.callback.getAndSet(null);
        if (callback == null) {
            return;
        }
        Callback callback2 = callback;
        callback2.onFailure(t);
    }

    private final void checkIfExecuted() {
        boolean bl = this.executed.compareAndSet(false, true);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Already Executed";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private static final void enqueue$lambda-0(ApolloStoreOperation this$0) {
        Object t;
        Intrinsics.checkParameterIsNotNull(this$0, "this$0");
        Object result = null;
        try {
            t = this$0.perform();
        }
        catch (Exception e) {
            this$0.notifyFailure(new ApolloException("Failed to perform store operation", e));
            return;
        }
        result = t;
        this$0.notifySuccess(result);
    }

    @JvmStatic
    @NotNull
    public static final <T> ApolloStoreOperation<T> emptyOperation(T result) {
        return Companion.emptyOperation(result);
    }

    @JvmStatic
    @NotNull
    public static final Executor emptyExecutor() {
        return Companion.emptyExecutor();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0015\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/apollographql/apollo/cache/normalized/ApolloStoreOperation$Callback;", "T", "", "onFailure", "", "t", "", "onSuccess", "result", "(Ljava/lang/Object;)V", "apollo-normalized-cache"})
    public static interface Callback<T> {
        public void onSuccess(T var1);

        public void onFailure(@NotNull Throwable var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J!\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0001\u0010\u00072\u0006\u0010\b\u001a\u0002H\u0007H\u0007\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/apollographql/apollo/cache/normalized/ApolloStoreOperation$Companion;", "", "()V", "emptyExecutor", "Ljava/util/concurrent/Executor;", "emptyOperation", "Lcom/apollographql/apollo/cache/normalized/ApolloStoreOperation;", "T", "result", "(Ljava/lang/Object;)Lcom/apollographql/apollo/cache/normalized/ApolloStoreOperation;", "apollo-normalized-cache"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <T> ApolloStoreOperation<T> emptyOperation(T result) {
            Executor executor = Companion.emptyExecutor();
            return new ApolloStoreOperation<T>(result, executor){
                final /* synthetic */ T $result;
                {
                    this.$result = $result;
                    super($super_call_param$1);
                }

                protected T perform() {
                    return this.$result;
                }

                public void enqueue(@Nullable Callback<T> callback) {
                    Callback<T> callback2 = callback;
                    if (callback2 != null) {
                        callback2.onSuccess(this.$result);
                    }
                }
            };
        }

        @JvmStatic
        @NotNull
        public final Executor emptyExecutor() {
            return Companion::emptyExecutor$lambda-0;
        }

        private static final void emptyExecutor$lambda-0(Runnable it) {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

